package cz.cuni.amis.pogamut.defcon.jason.arch;

import jason.architecture.AgArch;
import jason.asSyntax.Literal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;

import cz.cuni.amis.pogamut.defcon.jason.mainai.IJasonAI;

/**
 * General architecture for all agent architecture for Jason agents for Defcon.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public abstract class GeneralAgArch extends AgArch {

	protected IJasonAI mainAI;

	/**
	 * List of perceptions from the environment
	 */
	private List<Literal> percepts = new ArrayList<Literal>();

	public void prepAgArch(IJasonAI mainAI) {
		this.mainAI = mainAI;
	}

	@Override
	public List<Literal> perceive() {
		LinkedList<Literal> result = null;
		synchronized (percepts) {
			result = new LinkedList<Literal>(percepts); // it must be a copy!
		}
		return result;
	}

	public void addPercept(Literal percept) {
		synchronized (this.percepts) {
			this.percepts.add(percept);
		}
	}

	public void addPercept(LinkedList<Literal> percepts) {
		synchronized (this.percepts) {
			this.percepts.addAll(percepts);
		}
	}

	public abstract IJasonAI getAgent();

	public abstract void log(Level level, String message);
}
