package cz.cuni.amis.pogamut.defcon.jason.action;

import static jason.asSyntax.ASSyntax.createList;
import static jason.asSyntax.ASSyntax.createNumber;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Term;
import cz.cuni.amis.pogamut.defcon.jason.unitai.IJasonFleetAI;

/**
 * Returns all the fleet members of the given fleet.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class getFleetMembers extends AbstractInternalAction {

	@Override
	public Object executeWorker(TransitionSystem ts, Unifier un, Term[] args)
			throws Exception {

		// ts.getAg().getLogger()
		// .info("executing internal action 'getFleetMembers'");
		final IJasonFleetAI agent = (IJasonFleetAI) getAgent(ts);

		if (agent == null) {
			ts.getAg().getLogger()
					.info("'getFleetMembers' agent fail");
			return false;
		}

		if (args.length != 1) {
			ts.getAg().getLogger()
					.info("'getFleetMembers' args length");
			return false;
		}

		ListTerm fleetMembers = createList();
		for (int memberId : agent.getFleetMembers()) {
			fleetMembers.add(createNumber(memberId));
		}

		return un.unifies(args[0], fleetMembers);
	}

}
