/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.launcher;

import cz.cuni.amis.pogamut.episodic.decisions.Action;
import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.decisions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DMSLogger;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.Intention;
import decisionMakingSystem.PerceptiveField;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import pogamutEndEvent.IPogamutEndEventListener;
import pogamutEndEvent.PogamutEndAffordanceUsed;
import pogamutEndEvent.PogamutEndEvent;
import pogamutEndEvent.PogamutEndEventType;
import utils.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PogamutEndEventListener
implements IPogamutEndEventListener {
    public DMSLogger log = null;
    public AgentMemory mem = null;
    public boolean printAtomicActionExecutions = false;
    public ArrayList<Integer> saveTime = new ArrayList();
    private ArrayList<Boolean> saved = new ArrayList();
    public String saveFile;
    public int statsTime = 0;
    private boolean statsSaved = false;
    public String statsFile = "";
    public String readFrom = null;
    public String logEventsTo = null;
    public String getEventsFrom = null;
    private FileOutputStream evtLog = null;
    private ObjectOutputStream evtStream = null;

    public PogamutEndEventListener(AgentMemory _mem) {
        this.mem = _mem;
    }

    public void handlePogamutEndEvent(PogamutEndEvent evt) {
        if (this.logEventsTo != null) {
            try {
                if (this.evtStream == null) {
                    this.evtLog = new FileOutputStream(this.logEventsTo);
                    this.evtStream = new ObjectOutputStream(this.evtLog);
                }
                this.evtStream.writeObject(evt);
                this.evtStream.flush();
            }
            catch (Exception e) {
                System.err.println("Could not log pogamut end event!");
                System.err.println(e);
            }
        }
        if (this.log != null || evt.type == PogamutEndEventType.ATOMIC_ACTION_EXECUTED) {
            // empty if block
        }
        if (evt.trace != null && !evt.trace.isEmpty()) {
            for (int i = 0; i < evt.trace.size() - 1; ++i) {
                if (!((String)evt.trace.get(i)).equals(evt.trace.get(i + 1)) || !((String)evt.trace.get(i)).equals("IFixStuff")) continue;
                evt.trace.set(i, "AFixStuff");
            }
        }
        switch (evt.type) {
            case INIT_DECISION_TREE: {
                this.initDecisionTree(evt.intentionArea);
                break;
            }
            case ACTION_SUCCEEDED: 
            case ACTION_FAILED: {
                this.actionFinished(evt.type, evt.action, evt.trace);
                break;
            }
            case INTENTION_SUCCEEDED: 
            case INTENTION_FAILED: {
                this.intentionFinished(evt.type, evt.intention, evt.trace);
                break;
            }
            case ATOMIC_ACTION_EXECUTED: {
                this.atomicActionExecuted(evt.atomic, evt.trace, evt.affordances, evt.time);
                break;
            }
            case INTENTION_AREA: {
                this.reviewActiveIntentions(evt.intentionAreaS);
            }
        }
    }

    private void reviewActiveIntentions(ArrayList<String> intentions) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(intentions);
        if (intentions.size() == 1 && intentions.get(0).startsWith("_Want")) {
            return;
        }
        this.mem.reviewActiveIntentions(list);
    }

    private void atomicActionExecuted(String atomic, ArrayList<String> trace, ArrayList<PogamutEndAffordanceUsed> affs, int timer) {
        String atomicAction;
        ArrayList<AffordanceUsed> affordances = new ArrayList<AffordanceUsed>();
        for (PogamutEndAffordanceUsed pAff : affs) {
            affordances.add(new AffordanceUsed(pAff.usedOn, pAff.type, pAff.item));
        }
        String currentTime = "Time not available";
        if (timer != 0) {
            currentTime = TimeUtils.counterToDate((int)GMTTime.getRealTimeInTicks((int)timer));
            if (this.statsTime > 0 && !this.statsSaved && timer > this.statsTime) {
                this.statsSaved = true;
                this.mem.generateStatistics(this.statsFile);
            }
            if (!this.saveTime.isEmpty() && this.saved.isEmpty()) {
                for (int i = 0; i < this.saveTime.size(); ++i) {
                    this.saved.add(i, false);
                }
            }
            for (int i = 0; i < this.saveTime.size(); ++i) {
                if (this.saved.get(i).booleanValue() || timer <= this.saveTime.get(i)) continue;
                this.saveMemory(this.saveTime.get(i));
                this.saved.set(i, true);
            }
        }
        if (!currentTime.equals("Time not available")) {
            String time = currentTime.substring(0, 2);
            AffordanceUsed aff = new AffordanceUsed(trace.get(trace.size() - 1), "Day", time);
            affordances.add(aff);
        }
        if ((atomicAction = this.updateTrace(trace)) == null) {
            atomicAction = atomic;
        }
        if (trace.get(trace.size() - 1).startsWith("I")) {
            this.mem.addNewNode(atomicAction, trace, currentTime, affordances);
            if (this.printAtomicActionExecutions) {
                System.out.println("Executing atomic action " + atomic + "." + " " + currentTime);
            }
        } else {
            System.err.println("Invalid top level goal. Ignoring execution of atomic action " + atomic + ".");
        }
    }

    private void actionFinished(PogamutEndEventType type, String act, ArrayList<String> trace) {
        String name;
        boolean succeeded = false;
        if (type == PogamutEndEventType.ACTION_SUCCEEDED) {
            succeeded = true;
        }
        if ((name = this.updateTrace(trace)) == null) {
            name = act;
        }
        this.mem.nodeFinished(name, trace, succeeded);
    }

    private void intentionFinished(PogamutEndEventType type, String intention, ArrayList<String> trace) {
        String name;
        boolean succeeded = false;
        if (type == PogamutEndEventType.INTENTION_SUCCEEDED) {
            succeeded = true;
        }
        if ((name = this.updateTrace(trace)) == null) {
            name = intention;
        }
        this.mem.nodeFinished(name, trace, succeeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printVisibleItems(PerceptiveField perceptiveField) {
        HashMap visibleItems = null;
        HashMap hashMap = perceptiveField.allThings.visibleItems;
        synchronized (hashMap) {
            visibleItems = perceptiveField.allThings.visibleItems;
            String result = "Visible Items. Number of items: " + visibleItems.size() + "\r\n";
            for (EItem item : visibleItems.values()) {
                result = result + item.name + " attractivity: " + item.getAttractivity();
                result = result + " Affordances: ";
                for (Affordance affo : item.getAffordances()) {
                    result = result + affo.type + " " + affo.counter + " " + affo.attractivity + "\t";
                }
                result = result + "\r\n";
            }
            if (this.log != null) {
                this.log.writeAMessage(result + "\r\n");
            }
        }
    }

    private void printIntentions(ArrayList<Intention> intentionArea) {
        Intention temp = null;
        String result = "Active intentions: ";
        for (int index = 0; index < intentionArea.size(); ++index) {
            temp = intentionArea.get(index);
            if (temp.getAncestorAction() != null) {
                ++index;
                break;
            }
            result = result + temp.getName() + "|";
        }
        if (this.log != null) {
            this.log.writeAMessage(result + "\r\n");
        }
    }

    private cz.cuni.amis.pogamut.episodic.decisions.Intention parseIntention(Intention goal) {
        if (goal == null) {
            return null;
        }
        cz.cuni.amis.pogamut.episodic.decisions.Intention intention = new cz.cuni.amis.pogamut.episodic.decisions.Intention(goal.getName(), goal.attractivity);
        for (decisionMakingSystem.Action action : goal.getActions()) {
            intention.addSubNode(this.parseAction(action));
        }
        return intention;
    }

    private Action parseAction(decisionMakingSystem.Action action) {
        if (action == null) {
            return null;
        }
        Action act = new Action(action.name, action.attractivity);
        if (act.getName().equals("IFixStuff")) {
            act = new Action("AFixStuff", action.attractivity);
        }
        if (action.intentions != null) {
            for (Intention intention : action.intentions) {
                act.addSubNode(this.parseIntention(intention));
            }
        }
        if (action.satisfyingItems != null) {
            for (AffordanceType aff : action.satisfyingItems.keySet()) {
                if (aff == null) continue;
                AffordanceSlot slot = new AffordanceSlot(aff.name());
                act.addAffordance(slot);
            }
        }
        if (action.atomicActions != null) {
            for (atomicActions.AtomicAction atomicAction : action.atomicActions) {
                AtomicAction atomic = new AtomicAction(atomicAction.type.name(), atomicAction.attractivity);
                act.addAtomicAction(atomic);
            }
        }
        return act;
    }

    private void initDecisionTree(ArrayList<Intention> topLevelGoals) {
        if (!this.mem.getDecisionTree().topLevelGoals.isEmpty()) {
            this.mem.initVisualizers();
            return;
        }
        ArrayList<cz.cuni.amis.pogamut.episodic.decisions.Intention> intentions = null;
        intentions = new ArrayList<cz.cuni.amis.pogamut.episodic.decisions.Intention>();
        for (Intention goal : topLevelGoals) {
            intentions.add(this.parseIntention(goal));
        }
        this.mem.initialize(intentions);
        this.mem.initVisualizers();
        System.out.println("Number of top level goals: " + topLevelGoals.size());
        System.out.println("Number of atomic actions: " + this.mem.getDecisionTree().numberOfAtomicActions);
        System.out.println("Number of goals and actions: " + this.mem.getDecisionTree().numberOfNodes);
        System.out.println("Branching factor: " + this.mem.getDecisionTree().getBranchFactor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMemory(int time) {
        try {
            this.mem.sem.acquireUninterruptibly();
            String fileName = this.saveFile;
            fileName = fileName + time + ".mem";
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(this.mem);
            s.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.mem.sem.release();
        }
    }

    private String updateTrace(ArrayList<String> trace) {
        String result = null;
        if (trace.isEmpty()) {
            return "";
        }
        int index = trace.size();
        while (--index >= 0) {
            String s = trace.get(index);
            if (s.contains("_Want")) {
                result = s;
                trace.remove(index);
            }
            if (!s.contains("_Search")) continue;
            trace.remove(index);
        }
        if (result != null) {
            result = result.replace("_Want ", "Look for ");
        }
        return result;
    }
}

