/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.launcher;

import bot.Bot;
import com.thoughtworks.xstream.XStream;
import cz.cuni.amis.pogamut.episodic.launcher.PogamutEndEventListener;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.query.QueryModule;
import cz.cuni.amis.pogamut.episodic.visualizer.IVisualizationListener;
import cz.cuni.amis.pogamut.episodic.visualizer.VisualizationCreator;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Random;
import pogamutEndEvent.IPogamutEndEventListener;
import pogamutEndEvent.PogamutEndAffordanceUsed;
import pogamutEndEvent.PogamutEndEvent;
import pogamutEndEvent.PogamutEndEventType;

public class Launcher {
    static String readFrom = null;
    static String evtFrom = null;
    static String logEventsTo = null;
    static boolean saveMemory = false;
    static String saveFile = null;
    static ArrayList<Integer> saveTime = new ArrayList();
    static int startTime = 0;
    public static int statsTime = 0;
    public static String statsFile = null;
    static int nextAddTime = 720;
    static final int intervalTime = 1440;
    static final int maxAddTime = 27360;
    private static XStream xstream = new XStream();

    private static AgentMemory readMemory(String fileName) {
        try {
            FileInputStream in = new FileInputStream(fileName);
            ObjectInputStream s2 = new ObjectInputStream(in);
            AgentMemory mem = (AgentMemory)s2.readObject();
            mem.sem.release();
            return mem;
        }
        catch (IOException ex) {
            System.out.println("Exception in readMemory: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex2) {
            System.out.println("Exception in readMemory: " + ex2.getMessage());
        }
        return null;
    }

    private static void parseCommandLine(String[] args) {
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            String arg;
            if ((arg = args[i++]).equals("-readFrom")) {
                if (i < args.length) {
                    readFrom = args[i++];
                    continue;
                }
                System.err.println("-readFrom requires a filename");
                continue;
            }
            if (arg.equals("-startTime")) {
                if (i < args.length) {
                    try {
                        startTime = Integer.parseInt(args[i++]);
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        System.err.println("Could not parse startTime parameter!");
                    }
                    continue;
                }
                System.err.println("-startTime requires a parameter");
                continue;
            }
            if (arg.equals("-evtFrom")) {
                if (i < args.length) {
                    evtFrom = args[i++];
                    continue;
                }
                System.err.println("-evtFrom requires a filename");
                continue;
            }
            if (arg.equals("-logEvtTo")) {
                if (i < args.length) {
                    logEventsTo = args[i++];
                    continue;
                }
                System.err.println("-logEvtTo requires a filename");
                continue;
            }
            if (arg.equals("-statTime")) {
                if (i < args.length) {
                    try {
                        statsTime = Integer.parseInt(args[i++]);
                    }
                    catch (Exception e) {
                        System.err.println(e.toString());
                        System.err.println("Could not parse statTime parameter!");
                    }
                    continue;
                }
                System.err.println("-statTime requires a parameter");
                continue;
            }
            if (arg.equals("-statFile")) {
                if (i < args.length) {
                    statsFile = args[i++];
                    continue;
                }
                System.err.println("-statsFile requires a filename");
                continue;
            }
            if (arg.equals("-saveFile")) {
                if (i < args.length) {
                    saveFile = args[i++];
                    continue;
                }
                System.err.println("-saveFile requires a filename");
                continue;
            }
            if (!arg.equals("-saveTime")) continue;
            if (i < args.length) {
                try {
                    while (true) {
                        int parsed = Integer.parseInt(args[i]);
                        saveMemory = true;
                        ++i;
                        saveTime.add(parsed);
                    }
                }
                catch (Exception e) {
                    if (saveMemory) continue;
                    System.err.println(e.toString());
                    System.err.println("Could not parse statTime parameter!");
                    continue;
                }
            }
            System.err.println("-saveTime requires a parameter");
        }
        if (saveMemory && (saveFile == null || saveTime.isEmpty())) {
            saveMemory = false;
        }
    }

    public static void main(String[] args) {
        AgentMemory.visualize = true;
        AgentMemory mem = new AgentMemory();
        if (readFrom != null) {
            mem = Launcher.readMemory(readFrom);
        }
        new QueryModule(mem);
        VisualizationCreator viz = new VisualizationCreator();
        mem.addVisualizationListener((IVisualizationListener)viz);
        mem.initVisualizers();
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        if (saveMemory) {
            for (int i = 0; i < 28; ++i) {
                listener.saveTime.add(i * 24 * 60 + 0 + 5);
                listener.saveTime.add(i * 24 * 60 + 1380 + 55);
            }
            listener.saveFile = saveFile;
        }
        listener.statsFile = statsFile;
        listener.statsTime = statsTime;
        if (evtFrom != null) {
            try {
                FileInputStream evtLog = new FileInputStream(evtFrom);
                ObjectInputStream evtStream = new ObjectInputStream(evtLog);
                PogamutEndEvent evt = null;
                boolean passedStartTime = false;
                if (startTime == 0) {
                    passedStartTime = true;
                }
                while (true) {
                    evt = (PogamutEndEvent)evtStream.readObject();
                    if (evt.time > startTime) {
                        passedStartTime = true;
                    }
                    if (!passedStartTime) continue;
                    listener.handlePogamutEndEvent(evt);
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e);
            }
            catch (IOException e) {
                System.err.println(e);
            }
            catch (ClassNotFoundException e) {
                System.err.println(e);
            }
        } else {
            listener.logEventsTo = logEventsTo;
            Bot myBot = new Bot();
            Bot.noFrames = false;
            myBot.setPogamutEndEventListener((IPogamutEndEventListener)listener);
            Bot.TMP_TimeSpeed = 1.0;
            Bot.TMP_TimeStart = startTime;
        }
    }

    private static void generateEvents(int days, int multiplicator, String in, String out) {
        String evtIn = in;
        String evtTo = out;
        boolean initialized = false;
        int maxTime = days * 24 * 60;
        FileOutputStream evtLogOut = null;
        ObjectOutputStream evtStreamOut = null;
        try {
            evtLogOut = new FileOutputStream(evtTo);
            evtStreamOut = new ObjectOutputStream(evtLogOut);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < multiplicator; ++i) {
            try {
                FileInputStream evtLogIn = new FileInputStream(evtIn);
                ObjectInputStream evtStreamIn = new ObjectInputStream(evtLogIn);
                PogamutEndEvent evt = null;
                while (true) {
                    evt = null;
                    evt = (PogamutEndEvent)evtStreamIn.readObject();
                    if (evt.type == PogamutEndEventType.INIT_DECISION_TREE) {
                        if (initialized) continue;
                        initialized = true;
                    }
                    if (evt.time > maxTime) break;
                    evt.time += i * maxTime;
                    evtStreamOut.writeObject(evt);
                    if (evt.type != PogamutEndEventType.ATOMIC_ACTION_EXECUTED) continue;
                    Launcher.generateObserveAction(evt, evtStreamOut);
                }
                evtStreamOut.flush();
                evtStreamIn.close();
                evtLogIn.close();
                continue;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            evtStreamOut.close();
            evtLogOut.close();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        throw new RuntimeException("events generated");
    }

    private static void generateObserveAction(PogamutEndEvent evt, ObjectOutputStream out) throws IOException {
        int temp;
        PogamutEndAffordanceUsed aff;
        int i;
        int i2;
        if (evt.time < nextAddTime || evt.time > 27360) {
            return;
        }
        PogamutEndEvent evt2 = (PogamutEndEvent)xstream.fromXML(xstream.toXML((Object)evt));
        nextAddTime += 1440;
        evt2.atomic = "OBSERVE";
        evt2.trace.clear();
        evt2.trace.add("AObserve");
        evt2.trace.add("IObserve");
        evt2.affordances.clear();
        int totalRegularItems = 15;
        int seenRegularItems = 9;
        int totalRareItems = 25;
        int seenRareItems = 2;
        Random randomGenerator = new Random();
        int randomInt = 0;
        int[] valuesReg = new int[15];
        int[] valuesRar = new int[25];
        for (i2 = 0; i2 < 15; ++i2) {
            valuesReg[i2] = i2;
        }
        for (i2 = 0; i2 < 25; ++i2) {
            valuesRar[i2] = i2;
        }
        for (i = 0; i < 9; ++i) {
            aff = new PogamutEndAffordanceUsed("AObserve", "perceived", null);
            randomInt = randomGenerator.nextInt(15 - i);
            aff.item = "regular" + valuesReg[randomInt];
            temp = valuesReg[15 - i - 1];
            valuesReg[15 - i - 1] = valuesReg[randomInt];
            valuesReg[randomInt] = temp;
            evt2.affordances.add(aff);
        }
        for (i = 0; i < 2; ++i) {
            aff = new PogamutEndAffordanceUsed("AObserve", "perceived", null);
            randomInt = randomGenerator.nextInt(25 - i);
            aff.item = "rare" + valuesRar[randomInt];
            temp = valuesRar[25 - i - 1];
            valuesRar[25 - i - 1] = valuesRar[randomInt];
            valuesRar[randomInt] = temp;
            evt2.affordances.add(aff);
        }
        out.writeObject(evt2);
    }
}

