/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.episodic.launcher;

import cz.cuni.amis.pogamut.episodic.decisions.Intention;
import cz.cuni.amis.pogamut.episodic.episodes.Chronobag;
import cz.cuni.amis.pogamut.episodic.episodes.Episode;
import cz.cuni.amis.pogamut.episodic.launcher.PogamutEndEventListener;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import cz.cuni.amis.pogamut.episodic.query.ComboTexts;
import cz.cuni.amis.pogamut.episodic.query.QueryExecutor;
import decisionMakingSystem.GMTTime;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import pogamutEndEvent.PogamutEndAffordanceUsed;
import pogamutEndEvent.PogamutEndEvent;
import pogamutEndEvent.PogamutEndEventType;
import utils.TimeUtils;

public class LauncherTest {
    @Test
    public void testEventData() {
        AgentMemory.visualize = false;
        int maxTime = 10080;
        AgentMemory mem = new AgentMemory();
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        try {
            FileInputStream evtLog = new FileInputStream("inputEvents");
            ObjectInputStream evtStream = new ObjectInputStream(evtLog);
            PogamutEndEvent evt = null;
            do {
                evt = (PogamutEndEvent)evtStream.readObject();
                listener.handlePogamutEndEvent(evt);
            } while (evt.time <= maxTime);
        }
        catch (FileNotFoundException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail((String)"cannot find the input file");
        }
        catch (IOException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail((String)"IO exception");
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            System.out.println("Test testEventData skipped!");
            Assert.fail((String)"class not found exception");
        }
    }

    @Ignore
    @Test
    public void testExperimentFalseMemories() {
        AgentMemory mem = new AgentMemory();
        System.out.println("Starting false memory experiment");
        this.performExperimentFalseMemories(mem, "inputEvents", 2890);
    }

    @Ignore
    @Test
    public void testExperimentRoomSchema() {
        AgentMemory mem = new AgentMemory();
        Parameters.REMEMBER_SEEN_ITEMS = true;
        Parameters.MAX_OBJECT_SCORE = 42.0;
        Parameters.DEFAULT_OBJECT_SCORE = 22.0;
        Parameters.MIN_OBJECT_SCORE = 2.0;
        Parameters.PERCENTAGE_TO_DERIVE_OBJECT = 0.6;
        System.out.println("Starting room schema experiment (expected run time ~40s)");
        this.performExperimentRoomSchema(mem, "observeEvents", 32290);
    }

    @Ignore
    @Test
    public void testExperimentForgettingCurve() {
        AgentMemory mem = new AgentMemory();
        System.out.println("Starting forgetting curve experiment (expected run time ~?s)");
        this.performExperimentForgettingCurve(mem, "inputEvents", 29410);
    }

    @Ignore
    @Test
    public void Ignore_testExperiment7Days() {
        AgentMemory mem = new AgentMemory();
        Parameters.MAX_CHRONOBAG_LEVELS = 3;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[0] = 1;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[1] = 10;
        Parameters.CHRONOBAG_INTERVAL_LENGHTS[2] = 20;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 3;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 7;
        Parameters.LANDMARK_AGE_THRESHOLDS[0] = 11;
        Parameters.MAX_OBJECT_SCORE = 80.0;
        System.out.print("Starting 7 days experiment (expected run time ~40s)");
        this.performExperiment7Days(mem, "inputEvents", 144610);
    }

    public void performExperimentFalseMemories(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);
        ObjectInputStream evtStream = null;
        ObjectInputStream evtStreamFull = null;
        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
            FileInputStream evtLogFull = new FileInputStream(filename);
            evtStreamFull = new ObjectInputStream(evtLogFull);
        }
        catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentFalseMemories skipped!");
            Assert.fail();
        }
        HashMap<Integer, Integer> processed2full = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> full2processed = new HashMap<Integer, Integer>();
        AgentMemory memFull = new AgentMemory();
        PogamutEndEventListener listenerFull = new PogamutEndEventListener(memFull);
        QueryExecutor queryFull = new QueryExecutor(memFull);
        try {
            PogamutEndEvent evt = null;
            PogamutEndEvent evtFull = null;
            boolean maxDay = false;
            do {
                evt = (PogamutEndEvent)evtStream.readObject();
                evtFull = (PogamutEndEvent)evtStreamFull.readObject();
                Parameters.NO_FORGETTING = false;
                Parameters.NO_ABSTRACT_CHRONOBAGS = false;
                Parameters.NO_EPISODE_MERGING = false;
                listener.handlePogamutEndEvent(evt);
                Parameters.NO_FORGETTING = true;
                Parameters.NO_ABSTRACT_CHRONOBAGS = true;
                Parameters.NO_EPISODE_MERGING = true;
                listenerFull.handlePogamutEndEvent(evtFull);
                Integer id1 = mem.getLastEpisodeId();
                Integer id2 = memFull.getLastEpisodeId();
                if (id1 == null || id2 == null) continue;
                processed2full.put(id1, id2);
                full2processed.put(id2, id1);
            } while (evt.time <= maxTime);
            System.out.println("Max time reached.");
        }
        catch (IOException e) {
            System.out.println("End of input.");
        }
        catch (NullPointerException e) {
            System.err.println(e);
        }
        catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }
        int forgottenNodes = 0;
        int importedNodes = 0;
        int totalNodes = 0;
        for (Map.Entry entry : processed2full.entrySet()) {
            forgottenNodes += query.getNumberOfForgottenNodes((Integer)entry.getKey(), memFull, (Integer)entry.getValue(), true, false).intValue();
        }
        for (Map.Entry entry : full2processed.entrySet()) {
            importedNodes += queryFull.getNumberOfForgottenNodes((Integer)entry.getKey(), mem, (Integer)entry.getValue(), false, true).intValue();
        }
        for (Map.Entry entry : processed2full.entrySet()) {
            totalNodes += query.getNumberOfForgottenNodes(Integer.valueOf(0), memFull, (Integer)entry.getValue(), false, false).intValue();
        }
        System.out.println("Forgotten: " + forgottenNodes);
        System.out.println("Imported: " + importedNodes);
        System.out.println("Total: " + totalNodes);
    }

    public void performExperimentForgettingCurve(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);
        ObjectInputStream evtStream = null;
        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        }
        catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentForgettingCurve skipped!");
            Assert.fail();
        }
        HashMap<Integer, Integer> episodeAges = new HashMap<Integer, Integer>();
        try {
            PogamutEndEvent evt = null;
            do {
                evt = (PogamutEndEvent)evtStream.readObject();
                Chronobag last = mem.getPresentChronobag();
                Collection episodes = mem.getPresentChronobag().getEpisodes();
                listener.handlePogamutEndEvent(evt);
                if (mem.getPresentChronobag() == last) continue;
                for (Map.Entry entry : episodeAges.entrySet()) {
                    entry.setValue((Integer)entry.getValue() + 1);
                }
                for (Episode episode : episodes) {
                    episodeAges.put(episode.getIdEpisode(), 1);
                }
            } while (evt.time <= maxTime);
            System.out.println("Max time reached.");
        }
        catch (IOException e) {
            System.out.println("End of input.");
        }
        catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }
        Collection episodes = mem.getPresentChronobag().getEpisodes();
        for (Episode e : episodes) {
            episodeAges.put(e.getIdEpisode(), 0);
        }
        Map result = query.executeForgettingCurveQuery(episodeAges.keySet());
        HashMap totalRemembered = new HashMap();
        for (Integer n : episodeAges.keySet()) {
            if (!totalRemembered.containsKey(episodeAges.get(n))) {
                totalRemembered.put(episodeAges.get(n), result.get(n));
                continue;
            }
            totalRemembered.put(episodeAges.get(n), (Integer)totalRemembered.get(episodeAges.get(n)) + (Integer)result.get(n));
        }
        System.out.println("Number of nodes remembered by memory age (age = total):");
        System.out.println(totalRemembered);
    }

    public void performExperimentRoomSchema(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);
        ObjectInputStream evtStream = null;
        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        }
        catch (Exception e) {
            System.err.println(e);
            System.out.println("ExperimentRoomSchema skipped!");
            Assert.fail();
        }
        ArrayList<String> lastPerceived = new ArrayList<String>();
        try {
            PogamutEndEvent evt = null;
            do {
                evt = (PogamutEndEvent)evtStream.readObject();
                listener.handlePogamutEndEvent(evt);
                if (evt.atomic == null || !evt.atomic.equals("OBSERVE")) continue;
                lastPerceived.clear();
                for (PogamutEndAffordanceUsed aff : evt.affordances) {
                    if (!aff.usedOn.equals("AObserve")) continue;
                    lastPerceived.add(aff.item);
                }
            } while (evt.time <= maxTime);
            System.out.println("Max time reached.");
        }
        catch (IOException e) {
            System.out.println("End of input.");
        }
        catch (Exception e) {
            System.err.println(e);
            Assert.fail();
        }
        System.out.println("seen: " + lastPerceived);
        ArrayList remembered = query.executeRoomSchemaQuery();
        System.out.println("remembered: " + remembered);
        System.out.print("forgotten: ");
        for (String str : lastPerceived) {
            if (remembered.contains(str)) continue;
            System.out.print(str + ";");
        }
        System.out.println();
        System.out.print("added: ");
        for (String str : remembered) {
            if (lastPerceived.contains(str)) continue;
            System.out.print(str + ";");
        }
        System.out.println();
    }

    public Map<Integer, Double> performExperiment7Days(AgentMemory mem, String filename, int maxTime) {
        AgentMemory.visualize = false;
        PogamutEndEventListener listener = new PogamutEndEventListener(mem);
        QueryExecutor query = new QueryExecutor(mem);
        ObjectInputStream evtStream = null;
        try {
            FileInputStream evtLog = new FileInputStream(filename);
            evtStream = new ObjectInputStream(evtLog);
        }
        catch (Exception e) {
            System.err.println(e);
            System.out.println("Experiment7Days skipped!");
            Assert.fail();
        }
        Integer currentDayI = 0;
        String currentDayS = "";
        String currentTime = "";
        HashMap lastExecutionsI = new HashMap();
        HashMap lastExecutionsS = new HashMap();
        try {
            PogamutEndEvent evt = null;
            do {
                evt = (PogamutEndEvent)evtStream.readObject();
                listener.handlePogamutEndEvent(evt);
                if (evt.type != PogamutEndEventType.ATOMIC_ACTION_EXECUTED || evt.time <= 0) continue;
                currentTime = TimeUtils.counterToDate((int)GMTTime.getRealTimeInTicks((int)evt.time));
                currentDayI = Integer.parseInt(currentTime.substring(15, currentTime.length() - 1));
                currentDayS = currentTime.substring(0, 2);
                lastExecutionsI.put(evt.trace.get(evt.trace.size() - 1), currentDayI);
                lastExecutionsS.put(evt.trace.get(evt.trace.size() - 1), currentDayS);
            } while (evt.time <= maxTime);
        }
        catch (IOException e) {
            System.out.println("End of input.");
        }
        catch (ClassNotFoundException e) {
            System.err.println(e);
            Assert.fail();
        }
        System.out.println("Current day: " + currentDayI);
        String output = "";
        ArrayList days = new ArrayList();
        ArrayList<String> daysOfWeek = new ArrayList<String>();
        daysOfWeek.add("Mo");
        daysOfWeek.add("Tu");
        daysOfWeek.add("We");
        daysOfWeek.add("Th");
        daysOfWeek.add("Fr");
        daysOfWeek.add("Sa");
        daysOfWeek.add("Su");
        int currentDOW = -1;
        for (int i = 0; i < 7; ++i) {
            if (!currentDayS.equals(daysOfWeek.get(i))) continue;
            currentDOW = i;
        }
        if (currentDOW == -1) {
            Assert.fail();
        }
        HashMap<Integer, Double> errors = new HashMap<Integer, Double>();
        HashMap<Integer, Double> errorTotals = new HashMap<Integer, Double>();
        for (Intention n : mem.getDecisionTree().topLevelGoals.values()) {
            output = "Goal: ";
            output = output + n.getName();
            output = output + ". Last executed: ";
            if (lastExecutionsI.containsKey(n.getName())) {
                output = output + (String)lastExecutionsS.get(n.getName());
                output = output + ", " + (currentDayI - (Integer)lastExecutionsI.get(n.getName())) + " day(s) ago.";
            } else {
                output = output + "never.";
            }
            output = output + "\n";
            output = output + "Retrieved memory: ";
            String retrieved = query.executeQuery(ComboTexts.ComboType.COMBO_ACTIVITY, false, n.getName());
            output = output + retrieved;
            output = output + "\n";
            System.out.println(output);
            if (retrieved.equals("Don't remember.")) continue;
            Integer minDay = Integer.parseInt(retrieved.substring(0, retrieved.indexOf("-") - 1));
            Integer maxDay = Integer.parseInt(retrieved.substring(retrieved.indexOf("-") + 2, retrieved.indexOf("d") - 1));
            retrieved = retrieved.substring(retrieved.indexOf("[") + 1, retrieved.indexOf("]"));
            int deviation = 0;
            errors.clear();
            for (int i = minDay.intValue(); i <= maxDay; ++i) {
                int dow = i;
                while (currentDOW - dow < 0) {
                    dow -= 7;
                }
                if (!retrieved.contains((CharSequence)daysOfWeek.get((currentDOW - dow) % 7)) && !retrieved.equals("")) continue;
                deviation = Math.abs(i - (currentDayI - (Integer)lastExecutionsI.get(n.getName())));
                if (errors.get(deviation) == null) {
                    errors.put(deviation, 0.0);
                }
                errors.put(deviation, (Double)errors.get(deviation) + 1.0);
            }
            Double sum = 0.0;
            for (Double d : errors.values()) {
                sum = sum + d;
            }
            for (Integer key : errors.keySet()) {
                errors.put(key, (Double)errors.get(key) / sum);
                if (!errorTotals.containsKey(key)) {
                    errorTotals.put(key, 0.0);
                }
                errorTotals.put(key, errorTotals.get(key) + (Double)errors.get(key));
            }
        }
        System.out.println("Frequency of errors in dating events: (n days = x times, ...) ");
        System.out.println(errorTotals);
        return errorTotals;
    }
}

