package cz.cuni.amis.pogamut.episodic.launcher;

import atomicActions.AtomicAction;
import cz.cuni.amis.pogamut.episodic.decisions.AffordanceSlot;
import cz.cuni.amis.pogamut.episodic.memory.AffordanceUsed;
import cz.cuni.amis.pogamut.episodic.memory.AgentMemory;
import cz.cuni.amis.pogamut.episodic.memory.Parameters;
import decisionMakingSystem.Action;
import decisionMakingSystem.Affordance;
import decisionMakingSystem.AffordanceType;
import decisionMakingSystem.DMSLogger;
import decisionMakingSystem.EItem;
import decisionMakingSystem.GMTTime;
import decisionMakingSystem.Intention;
import decisionMakingSystem.PerceptiveField;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import pogamutEndEvent.IPogamutEndEventListener;
import pogamutEndEvent.PogamutEndAffordanceUsed;
import pogamutEndEvent.PogamutEndEvent;
import pogamutEndEvent.PogamutEndEventType;
import utils.TimeUtils;


/**
 *
 * @author Miso
 */
public class PogamutEndEventListener implements IPogamutEndEventListener {
    public DMSLogger log = null;
    public AgentMemory mem = null;

    public boolean printAtomicActionExecutions = false;

    public ArrayList<Integer> saveTime = new ArrayList<Integer>();
    private ArrayList<Boolean> saved = new ArrayList<Boolean>();
    public String saveFile;
    public int statsTime = 0;
    private boolean statsSaved = false;
    public String statsFile = "";

    public String readFrom = null;
    public String logEventsTo = null;
    public String getEventsFrom = null;
    private FileOutputStream evtLog = null;
    private ObjectOutputStream evtStream = null;

    public PogamutEndEventListener(AgentMemory _mem) {
        mem = _mem;
    }

    @Override
    public void handlePogamutEndEvent(PogamutEndEvent evt) {
        if (logEventsTo != null) {
            try {
                if (evtStream == null) {
                    evtLog = new FileOutputStream(logEventsTo);
                    evtStream = new ObjectOutputStream(evtLog);
                }
                evtStream.writeObject(evt);
                evtStream.flush();
            } catch (Exception e) {
                System.err.println("Could not log pogamut end event!");
                System.err.println(e);
            }
        }

        if (log == null && evt.type == PogamutEndEventType.ATOMIC_ACTION_EXECUTED) {
      //      if (evt.atomicAct.agent != null) {
      //          log = new DMSLogger(evt.atomicAct.agent.getDecisions().log, "mylog.txt");
      //      }
        }

        //WORKAROUND NEEDED BECAUSE OF A TYPO IN IDUTIES.XML
        if (evt.trace != null && !evt.trace.isEmpty()) {
            for (int i = 0; i < evt.trace.size() - 1; i++) {
                if (evt.trace.get(i).equals(evt.trace.get(i+1))) {
                    if (evt.trace.get(i).equals("IFixStuff")) {
                        evt.trace.set(i, "AFixStuff");
                    }
                }
            }
        }

        switch (evt.type) {
            case INIT_DECISION_TREE:
                initDecisionTree(evt.intentionArea);
                break;
            case ACTION_SUCCEEDED:
            case ACTION_FAILED:
                actionFinished(evt.type, evt.action, evt.trace);
                break;
            case INTENTION_SUCCEEDED:
            case INTENTION_FAILED:
                intentionFinished(evt.type, evt.intention, evt.trace);
                break;
            case ATOMIC_ACTION_EXECUTED:
                atomicActionExecuted(evt.atomic, evt.trace, evt.affordances, evt.time);
         //       if (evt.atomicAct.agent != null) {
         //           printVisibleItems(evt.atomicAct.agent.getDecisions().perceptiveField);
         //       }
                break;
            case INTENTION_AREA:
                reviewActiveIntentions(evt.intentionAreaS);
           //     printIntentions(evt.intentionArea);
                break;
        }
    }

    private void reviewActiveIntentions(ArrayList<String> intentions) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(intentions);
        if (intentions.size() == 1 && intentions.get(0).startsWith("_Want")) {
            return;
        }
        mem.reviewActiveIntentions(list);
    }

    private void atomicActionExecuted(String atomic, ArrayList<String> trace, ArrayList<PogamutEndAffordanceUsed> affs, int timer) {
        ArrayList<AffordanceUsed> affordances = new ArrayList<AffordanceUsed>();
        for (PogamutEndAffordanceUsed pAff : affs) {
            affordances.add(new AffordanceUsed(pAff.usedOn, pAff.type, pAff.item));
        }

        String currentTime = "Time not available";
        if (timer != 0) {
            currentTime = TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(timer));

            if (statsTime > 0 && !statsSaved && timer > statsTime) {
                statsSaved = true;
                mem.generateStatistics(statsFile);
            }

            if (!saveTime.isEmpty() && saved.isEmpty()) {
                for (int i=0; i < saveTime.size(); i++) {
                    saved.add(i, false);
                }
            }
            for (int i = 0; i < saveTime.size(); i++) {
                if (!saved.get(i) && timer > saveTime.get(i)) {
                  saveMemory(saveTime.get(i));
                  saved.set(i, true);
                }
            }
        }

        if (!currentTime.equals("Time not available")) {
            //format of time is: "Fr, 03:44, day 12."
            String time = currentTime.substring(0, 2);
            AffordanceUsed aff = new AffordanceUsed(trace.get(trace.size() - 1),"Day",time);
            affordances.add(aff);
        }

        String atomicAction = updateTrace(trace);
        if (atomicAction == null) {
            atomicAction = atomic;
        }

        if (trace.get(trace.size() - 1).startsWith("I")) {
            mem.addNewNode(atomicAction, trace, currentTime, affordances);
            if (printAtomicActionExecutions) {
                System.out.println("Executing atomic action "+atomic+"." + " " + currentTime);
            }
        } else {
            System.err.println("Invalid top level goal. Ignoring execution of atomic action "+atomic+".");
        }

  /*      String result = "AtomicActionExecuted:" + act.type.toString() + " ";
        try {
            result += " Succeded:";
            if (act.succeeded()) result += "yes "; else result += "no ";
            result += " Failed:";
            if (act.failed()) result += "yes "; else result += "no ";
        } catch (Exception e) {

        }
        result += "\r\nStart time: " + act.actionStart;
        result += " = " + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(act.actionStart));
        if (act.dModule != null) {
            result += "\r\nCurrent time: " + act.dModule.counter;
            result += " = " + currentTime;
        }
        result += "\r\ntrace: ";

        parentAction = act.parent;
        while (parentAction!= null) {
            result += parentAction.name+"|";
            parentIntention = parentAction.intention;
            if (parentIntention == null) break;
            result += parentIntention.getName()+"|";
            parentAction = parentIntention.getAncestorAction();
        }
        if (log != null) log.writeAMessage(result+"\r\n"); */
    }

    private void actionFinished(PogamutEndEventType type, String act, ArrayList<String> trace) {
        boolean succeeded = false;
        if (type == PogamutEndEventType.ACTION_SUCCEEDED) succeeded = true;
        String name = updateTrace(trace);
        if (name == null) name = act;
        mem.nodeFinished(name, trace, succeeded);

  /*      String result = type.name() + ": " + act.name + "\r\n";
        result += "Start time: " + act.start;
        result += " = " + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(act.start));
        result += "\r\nDuration: " + act.time;
        result += " = " + TimeUtils.counterToTime(GMTTime.getRealTimeInTicks(act.time));
        result += "\r\nAction affordances: ";
        for (AffordanceType aff : act.satisfyingItems.keySet()) {
            EItem item = act.satisfyingItems.get(aff);
            if (item == null) break;
            result += aff.name() + ":" + item.name + "; ";
        }
        if (log != null) log.writeAMessage(result+"\r\n"); */
    }
    private void intentionFinished(PogamutEndEventType type, String intention, ArrayList<String> trace) {
        boolean succeeded = false;
        if (type == PogamutEndEventType.INTENTION_SUCCEEDED) succeeded = true;
        String name = updateTrace(trace);
        if (name == null) name = intention;
        mem.nodeFinished(name, trace, succeeded);

   /*     String result = type.name() + ": " + intention.getName() + "\r\n";
        result += "Duration: " + intention.getDuration();
        result += " = " + TimeUtils.counterToDate(GMTTime.getRealTimeInTicks(intention.getDuration()));
        result += "\r\nTime in memory: " + intention.getMemoryDuration();
        result += " = " + TimeUtils.counterToTime(GMTTime.getRealTimeInTicks(intention.getMemoryDuration()));
        if (log != null) log.writeAMessage(result+"\r\n");*/
    }

    private void printVisibleItems(PerceptiveField perceptiveField) {
        HashMap<Long, EItem> visibleItems = null;
        synchronized (perceptiveField.allThings.visibleItems) {
            visibleItems = perceptiveField.allThings.visibleItems;

            String result = "Visible Items. Number of items: " + visibleItems.size() + "\r\n";
            for (EItem item : visibleItems.values()) {
                result += item.name + " attractivity: " + item.getAttractivity();
                result += " Affordances: ";
                for (Affordance affo : item.getAffordances()) {
                  result += affo.type + " " + affo.counter + " " + affo.attractivity + "\t";
                }
            result += "\r\n";
            }
            if (log != null) log.writeAMessage(result+"\r\n");
        }
    }

    private void printIntentions(ArrayList<Intention> intentionArea) {
        int index = 0;
        Intention temp = null;
        String result = "Active intentions: ";
        for (; index < intentionArea.size();) {
            temp = intentionArea.get(index);
            if (temp.getAncestorAction() != null) {
                index++;
                break;
            }
//            if (temp.isEnabled()) {
                result += temp.getName() + "|";
  //          }
            index++;
        }
        if (log != null) log.writeAMessage(result+"\r\n");
    }

    private cz.cuni.amis.pogamut.episodic.decisions.Intention parseIntention(Intention goal) {
        if (goal == null) return null;

        cz.cuni.amis.pogamut.episodic.decisions.Intention intention = new cz.cuni.amis.pogamut.episodic.decisions.Intention(goal.getName(), goal.attractivity);
        for (Action action : goal.getActions()) {
            intention.addSubNode(parseAction(action));
        }
        return intention;
    }

    private cz.cuni.amis.pogamut.episodic.decisions.Action parseAction(Action action) {
        if (action == null) return null;
        cz.cuni.amis.pogamut.episodic.decisions.Action act = new cz.cuni.amis.pogamut.episodic.decisions.Action(action.name, action.attractivity);

            //WORKAROUND NEEDED BECAUSE OF A TYPO IN "IDUTIES.XML"
            if (act.getName().equals("IFixStuff")) {
                act = new cz.cuni.amis.pogamut.episodic.decisions.Action("AFixStuff", action.attractivity);
            }

        if (action.intentions != null)
            for (Intention intention : action.intentions) {
                act.addSubNode(parseIntention(intention));
            }
        if (action.satisfyingItems != null)
            for (AffordanceType aff : action.satisfyingItems.keySet()) {
                if (aff == null) continue;
                AffordanceSlot slot = new AffordanceSlot(aff.name());
                act.addAffordance(slot);
            }
        if (action.atomicActions != null)
            for (AtomicAction atomicAction : action.atomicActions) {
                cz.cuni.amis.pogamut.episodic.decisions.AtomicAction atomic = new cz.cuni.amis.pogamut.episodic.decisions.AtomicAction(atomicAction.type.name(), atomicAction.attractivity);
                act.addAtomicAction(atomic);
            }
        return act;
    }

    private void initDecisionTree(ArrayList<Intention> topLevelGoals) {
        if (!mem.getDecisionTree().topLevelGoals.isEmpty()) {
            //TODO: check correct intentions
            mem.initVisualizers();
            return;
        }

        ArrayList<cz.cuni.amis.pogamut.episodic.decisions.Intention> intentions = null;
        intentions = new ArrayList<cz.cuni.amis.pogamut.episodic.decisions.Intention>();
        for (Intention goal : topLevelGoals) {
            intentions.add(parseIntention(goal));
        }
        mem.initialize(intentions);
        mem.initVisualizers();

        System.out.println("Number of top level goals: " + topLevelGoals.size());
        System.out.println("Number of atomic actions: "+ mem.getDecisionTree().numberOfAtomicActions);
        System.out.println("Number of goals and actions: "+ mem.getDecisionTree().numberOfNodes);
        System.out.println("Branching factor: "+ mem.getDecisionTree().getBranchFactor());
    }

    private void saveMemory(int time) {
        try {
            mem.sem.acquireUninterruptibly();
            String fileName = saveFile;
            fileName += time + ".mem";
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream s = new ObjectOutputStream(f);
            s.writeObject(mem);
            s.flush();
        } catch (IOException ex) {
        } finally {
            mem.sem.release();
        }
    }

    /**
     * Updates the trace so the want and search nodes are replaced with single node
     *
     * @param trace List of node names from top-level goal to atomic action
     * @return Return the name of node the bottom nodes were replaced with or null.
     */
    private String updateTrace(ArrayList<String> trace) {
        String result = null;
        if (trace.isEmpty()) return "";
        int index = trace.size();
        while (--index >= 0) {
            String s = trace.get(index);
            if (s.contains("_Want")) {
                result = s;
                trace.remove(index);
            }
            if (s.contains("_Search")) {
                trace.remove(index);
            }
        }
        if (result != null) {
            result = result.replace("_Want ","Look for ");
        }
        return result;
    }

}
