/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.Domain;
import JSHOP2.InternalVars;
import JSHOP2.Plan;
import JSHOP2.State;
import JSHOP2.TaskList;
import JSHOP2.Term;
import JSHOP2.TermConstant;
import JSHOP2.TermVariable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class JSHOP2 {
    private final Logger logger = Logger.getLogger(JSHOP2.class);
    private Plan currentPlan;
    private Domain domain;
    private int planNo;
    private LinkedList plans;
    private Plan bestPlan;
    private int numPlansFound;
    private boolean keepOnlyBestPlan;
    private State state;
    private TaskList tasks;
    private TermConstant[] constants;
    private TermVariable[] variables;
    private boolean cancelled = false;
    private boolean branchAndBound = false;
    private double costBound;
    private int level;

    public Plan branchAndBound(TaskList taskIn) {
        this.findPlans(taskIn, 0, true, true);
        return this.bestPlan;
    }

    public Plan branchAndBound(TaskList taskIn, int planNoIn) {
        this.findPlans(taskIn, planNoIn, true, true);
        return this.bestPlan;
    }

    public LinkedList findPlans(TaskList tasksIn, int planNoIn) {
        this.findPlans(tasksIn, planNoIn, false, false);
        return this.plans;
    }

    public void findPlans(TaskList tasksIn, int planNoIn, boolean branchAndBoundIn, boolean keepOnlyBestIn) {
        this.cancelled = false;
        this.plans = new LinkedList();
        this.bestPlan = null;
        this.numPlansFound = 0;
        this.keepOnlyBestPlan = keepOnlyBestIn;
        this.currentPlan = new Plan();
        this.tasks = tasksIn;
        this.planNo = planNoIn;
        this.branchAndBound = branchAndBoundIn;
        this.costBound = Double.POSITIVE_INFINITY;
        this.level = 0;
        this.findPlanHelper(this.tasks);
    }

    private boolean findPlanHelper(TaskList chosenTask) {
        if (this.cancelled) {
            return false;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getIndentString(this.level) + "Decomposing " + chosenTask.toString(this)));
        }
        ++this.level;
        InternalVars v = new InternalVars();
        v.t0 = chosenTask.getFirst();
        if (v.t0.size() == 0) {
            if (chosenTask != this.tasks) {
                boolean continuePlanning = this.findPlanHelper(this.tasks);
                --this.level;
                return continuePlanning;
            }
            if (this.branchAndBound && this.currentPlan.getCost() < this.costBound) {
                this.costBound = this.currentPlan.getCost();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Cost bound improved: " + this.costBound));
                }
            }
            if (this.bestPlan == null || this.currentPlan.getCost() < this.bestPlan.getCost()) {
                this.bestPlan = (Plan)this.currentPlan.clone();
            }
            if (!this.keepOnlyBestPlan) {
                if (this.planNo != 1) {
                    this.plans.addLast(this.currentPlan.clone());
                } else {
                    this.plans.addLast(this.currentPlan);
                }
            }
            ++this.numPlansFound;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Plan found");
            }
            return true;
        }
        v.delAdd = new Vector[4];
        for (TaskList v.tl : v.t0) {
            v.t = v.tl.getTask();
            if (v.t.isPrimitive()) {
                v.tl.replace(TaskList.empty);
                v.o = this.domain.ops[v.t.getHead().getHead()];
                v.j = 0;
                while (v.j < v.o.length) {
                    v.binding = v.o[v.j].unify(v.t.getHead());
                    if (v.binding != null) {
                        v.p = v.o[v.j].getIterator(v.binding, 0);
                        while ((v.nextB = v.p.nextBinding()) != null) {
                            Term.merge(v.nextB, v.binding);
                            if (v.o[v.j].apply(v.nextB, this.state, v.delAdd)) {
                                double cost = this.currentPlan.addOperator(v.o[v.j], v.nextB);
                                if ((!this.branchAndBound || this.currentPlan.getCost() < this.costBound) && this.findPlanHelper(this.tasks) && this.planNo > 0 && this.numPlansFound >= this.planNo) {
                                    --this.level;
                                    return true;
                                }
                                if (this.cancelled) {
                                    return false;
                                }
                                this.currentPlan.removeOperator(cost);
                            }
                            this.state.undo(v.delAdd);
                        }
                    }
                    ++v.j;
                }
                v.tl.undo();
                continue;
            }
            v.m = this.domain.methods[v.t.getHead().getHead()];
            v.j = 0;
            while (v.j < v.m.length) {
                v.binding = v.m[v.j].unify(v.t.getHead());
                if (v.binding != null) {
                    v.found = false;
                    v.k = 0;
                    while (v.k < v.m[v.j].getSubs().length && !v.found) {
                        v.p = v.m[v.j].getIterator(v.binding, v.k);
                        while ((v.nextB = v.p.nextBinding()) != null) {
                            Term.merge(v.nextB, v.binding);
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)(this.getIndentString(this.level) + "Trying method " + this.domain.compoundTasks[v.m[v.j].getHead().getHead()] + " - " + v.m[v.j].getLabel(v.k)));
                            }
                            v.tl.replace(v.m[v.j].getSubs()[v.k].bind(v.nextB));
                            if (this.findPlanHelper(v.tl) && this.planNo > 0 && this.numPlansFound >= this.planNo) {
                                return true;
                            }
                            if (this.cancelled) {
                                return false;
                            }
                            v.found = true;
                            v.tl.undo();
                        }
                        ++v.k;
                    }
                }
                ++v.j;
            }
        }
        --this.level;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.getIndentString(this.level) + "Stopped decomposing " + chosenTask.toString(this)));
        }
        return false;
    }

    private String getIndentString(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public State getState() {
        return this.state;
    }

    public TermConstant getConstant(int index) {
        return this.constants[index];
    }

    public TermVariable getVariable(int index) {
        return this.variables[index];
    }

    public void initializeVars(int varsMaxSize) {
        this.variables = new TermVariable[varsMaxSize];
        for (int i = 0; i < varsMaxSize; ++i) {
            this.variables[i] = new TermVariable(i);
        }
    }

    public void initializeConstants(int numConstants) {
        TermConstant[] oldConstants = this.constants != null ? this.constants : new TermConstant[]{};
        this.constants = new TermConstant[numConstants];
        for (int i = 0; i < numConstants; ++i) {
            this.constants[i] = i < oldConstants.length ? oldConstants[i] : new TermConstant(i);
        }
    }

    public void initialize(Domain d, int numConstants) {
        this.initializeConstants(numConstants);
        this.domain = d;
        this.cancelled = false;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public Plan getBestPlan() {
        return this.bestPlan;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getNumPlansFound() {
        return this.numPlansFound;
    }

    public List<Plan> getPlansCopy() {
        return new ArrayList<Plan>(this.plans);
    }
}

