/*
 * Decompiled with CFR 0.152.
 */
package JSHOP2;

import JSHOP2.CompileTimeObject;
import JSHOP2.JSHOP2;
import JSHOP2.TaskAtom;
import JSHOP2.Term;
import java.util.LinkedList;
import java.util.Vector;

public class TaskList
extends CompileTimeObject {
    public static TaskList empty = new TaskList();
    private boolean ordered;
    public TaskList[] subtasks;
    private TaskAtom task;

    private TaskList() {
        this.ordered = true;
        this.subtasks = new TaskList[0];
        this.task = null;
    }

    public TaskList(TaskAtom taskIn) {
        this.ordered = true;
        this.subtasks = null;
        this.task = taskIn;
    }

    public TaskList(int size, boolean orderedIn) {
        this.ordered = orderedIn;
        this.subtasks = new TaskList[size];
        this.task = null;
    }

    public TaskList bind(Term[] binding) {
        if (this.subtasks == null) {
            return new TaskList(this.task.bind(binding));
        }
        TaskList retVal = new TaskList(this.subtasks.length, this.ordered);
        for (int i = 0; i < this.subtasks.length; ++i) {
            retVal.subtasks[i] = this.subtasks[i].bind(binding);
        }
        return retVal;
    }

    public static TaskList createTaskList(Vector subtasksIn, boolean orderedIn) {
        if (subtasksIn.size() == 0) {
            return empty;
        }
        TaskList retVal = new TaskList(subtasksIn.size(), orderedIn);
        for (int i = 0; i < subtasksIn.size(); ++i) {
            retVal.subtasks[i] = (TaskList)subtasksIn.get(i);
        }
        return retVal;
    }

    public LinkedList getFirst() {
        LinkedList retVal = new LinkedList();
        this.getFirstHelper(retVal);
        return retVal;
    }

    private boolean getFirstHelper(LinkedList res) {
        if (this.subtasks == null) {
            if (this.task.isImmediate()) {
                res.clear();
                res.add(this);
                return true;
            }
            res.add(this);
            return false;
        }
        if (this.ordered) {
            int listSize = res.size();
            for (int i = 0; i < this.subtasks.length; ++i) {
                if (this.subtasks[i].getFirstHelper(res)) {
                    return true;
                }
                if (res.size() == listSize) continue;
                return false;
            }
            return false;
        }
        for (int i = 0; i < this.subtasks.length; ++i) {
            if (!this.subtasks[i].getFirstHelper(res)) continue;
            return true;
        }
        return false;
    }

    public String getInitCode(String what) {
        if (this.isEmpty()) {
            return "\t\t" + what + " = TaskList.empty;" + endl;
        }
        if (this.subtasks == null) {
            return "\t\t" + what + " = new TaskList(" + this.task.toCode() + ");" + endl;
        }
        String s = "\t\t" + what + " = new TaskList(" + this.subtasks.length + ", " + this.ordered + ");" + endl;
        for (int i = 0; i < this.subtasks.length; ++i) {
            s = s + this.subtasks[i].getInitCode(what + ".subtasks[" + i + "]");
        }
        return s;
    }

    public TaskAtom getTask() {
        return this.task;
    }

    public boolean isEmpty() {
        if (this.subtasks == null) {
            return false;
        }
        for (int i = 0; i < this.subtasks.length; ++i) {
            if (this.subtasks[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void print() {
        System.out.println(this);
    }

    public void replace(TaskList tasksIn) {
        this.subtasks = tasksIn.subtasks;
    }

    public void setVarCount(int varCountIn) {
        if (this.subtasks == null) {
            this.task.getHead().setVarCount(varCountIn);
        } else {
            for (int i = 0; i < this.subtasks.length; ++i) {
                this.subtasks[i].setVarCount(varCountIn);
            }
        }
    }

    @Override
    public String toCode() {
        return "\t\tTaskList retVal;" + endl + endl + this.getInitCode("retVal") + endl + "\t\treturn retVal;" + endl;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(JSHOP2 context) {
        if (this.isEmpty()) {
            return "()";
        }
        if (this.subtasks == null) {
            if (context != null) {
                return this.task.toString(context);
            }
            return this.task.toString();
        }
        String s = "(";
        if (!this.ordered) {
            s = s + ":unordered";
        }
        for (int i = 0; i < this.subtasks.length; ++i) {
            if (this.subtasks[i].isEmpty()) continue;
            if (!s.equals("(")) {
                s = s + " ";
            }
            s = context != null ? s + this.subtasks[i].toString(context) : s + this.subtasks[i].toString();
        }
        return s + ")";
    }

    public void undo() {
        this.subtasks = null;
    }
}

