/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import cz.cuni.amis.planning4j.PlanningException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLUtilities {
    public static Document readFromFile(String fname) throws JDOMException, IOException {
        SAXBuilder sxb = new SAXBuilder();
        return sxb.build(new File(fname));
    }

    public static Element readPlannerListFromStream(InputStream stream) {
        Document doc;
        SAXBuilder sxb = new SAXBuilder();
        try {
            doc = sxb.build(stream);
        }
        catch (JDOMException ex) {
            Logger.getLogger(XMLUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlanningException("Unable to read planner list", (Throwable)ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XMLUtilities.class.getName()).log(Level.SEVERE, null, ex);
            throw new PlanningException("Unable to read planner list", (Throwable)ex);
        }
        return doc.getRootElement();
    }

    public static void writeToFile(String fname, Document doc) {
        try {
            FileOutputStream out = new FileOutputStream(fname);
            Format format = Format.getPrettyFormat();
            format.setIndent("\t");
            format.setEncoding("ISO-8859-1");
            XMLOutputter op = new XMLOutputter(format);
            op.output(doc, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static int getId(Element parent) {
        List children = parent.getChildren();
        Iterator it = children.iterator();
        int idM = 0;
        while (it.hasNext()) {
            Element el1 = (Element)it.next();
            int id = Integer.valueOf(el1.getAttributeValue("id"));
            if (id <= idM) continue;
            idM = id;
        }
        return idM + 1;
    }

    public static Element getElement(Element parent, String id) {
        Element element = null;
        try {
            JDOMXPath path = new JDOMXPath("child::*[@id='" + id + "']");
            element = (Element)path.selectSingleNode((Object)parent);
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        return element;
    }

    public static void printXML(Element element) {
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        XMLOutputter op = new XMLOutputter(format);
        if (element == null) {
            System.err.println("Null element");
        } else {
            try {
                op.output(element, (OutputStream)System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println();
        }
    }

    public static void printXML(Document doc) {
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        XMLOutputter op = new XMLOutputter(format);
        if (doc == null) {
            System.err.println("Null document");
        } else {
            try {
                op.output(doc, (OutputStream)System.out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            System.out.println();
        }
    }

    public static String toString(Element element) {
        String content = "";
        Format format = Format.getPrettyFormat();
        format.setIndent("\t");
        XMLOutputter op = new XMLOutputter(format);
        if (element == null) {
            System.err.println("Null element");
        } else {
            content = op.outputString(element);
        }
        return content;
    }

    public static List<Element> getClassAscendents(Element childClass) {
        ArrayList<Element> parents = new ArrayList<Element>();
        boolean hasParent = true;
        Element parent = childClass;
        while (hasParent) {
            if (!parent.getChildText("type").equals("Primitive")) {
                if (!parent.getChild("generalization").getAttributeValue("id").equals("")) {
                    parent = XMLUtilities.getElement(parent.getParentElement(), parent.getChild("generalization").getAttributeValue("id"));
                    hasParent = true;
                    parents.add(parent);
                    continue;
                }
                hasParent = false;
                continue;
            }
            hasParent = false;
        }
        return parents;
    }

    public static List<Element> getClassDescendents(Element parentClass) {
        ArrayList<Element> descendents = new ArrayList<Element>();
        XMLUtilities.getClassDescendents(parentClass, descendents);
        return descendents;
    }

    private static void getClassDescendents(Element parentClass, List<Element> descendents) {
        List result = null;
        try {
            JDOMXPath path = new JDOMXPath("class[generalization/@element='class' and generalization/@id='" + parentClass.getAttributeValue("id") + "']");
            result = path.selectNodes((Object)parentClass.getParentElement());
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        for (Element child : result) {
            descendents.add(child);
            XMLUtilities.getClassDescendents(child, descendents);
        }
    }

    public static Element getClassesHierarchyTree(Element project) {
        Element tree = new Element("hierarchy");
        List classes = null;
        try {
            JDOMXPath path = new JDOMXPath("project/elements/classes/class[stereotype!='utility' and type!='Primitive' and generalization[@id='']]");
            classes = path.selectNodes((Object)project.getDocument());
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        for (Element currentClass : classes) {
            Element highClassTree = XMLUtilities.getClassDescendenceTree(currentClass);
            tree.addContent((Content)highClassTree);
        }
        return tree;
    }

    private static Element getClassDescendenceTree(Element child) {
        Element highClass = new Element("class");
        highClass.setAttribute("name", child.getChildText("name"));
        highClass.setAttribute("id", child.getAttributeValue("id"));
        List result = null;
        try {
            JDOMXPath path = new JDOMXPath("class[generalization/@element='class' and generalization/@id='" + child.getAttributeValue("id") + "']");
            result = path.selectNodes((Object)child.getParentElement());
        }
        catch (JaxenException e) {
            e.printStackTrace();
        }
        for (Element grandchild : result) {
            Element grandchildTree = XMLUtilities.getClassDescendenceTree(grandchild);
            highClass.addContent((Content)grandchildTree);
        }
        return highClass;
    }

    public static void main(String[] args) {
        Element project = null;
        try {
            project = XMLUtilities.readFromFile("examples/DepotDomain.xml").getRootElement();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (project != null) {
            Element tree = XMLUtilities.getClassesHierarchyTree(project);
            XMLUtilities.printXML(tree);
        }
    }
}

