/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import cz.cuni.amis.planning4j.external.impl.itsimple.ENoPlanFoundSignalType;
import cz.cuni.amis.planning4j.external.impl.itsimple.EPlannerPlatform;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerSettings;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimpleUtils;
import cz.cuni.amis.planning4j.external.impl.itsimple.PlannerArgument;
import cz.cuni.amis.planning4j.pddl.PDDLRequirement;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

public class SimplePlannerListManager {
    protected Element plannersXml;

    public SimplePlannerListManager(Element plannersXml) {
        this.plannersXml = plannersXml;
    }

    public ItSimplePlannerInformation readInformationFromXML(Element plannerElement) {
        ItSimplePlannerInformation information = new ItSimplePlannerInformation();
        if (plannerElement.getChild("name") != null) {
            information.setName(plannerElement.getChildText("name"));
        }
        if (plannerElement.getChild("version") != null) {
            information.setVersion(plannerElement.getChildText("version"));
        }
        if (plannerElement.getChild("date") != null) {
            information.setDate(plannerElement.getChildText("date"));
        }
        if (plannerElement.getChild("author") != null) {
            information.setAuthor(plannerElement.getChildText("author"));
        }
        if (plannerElement.getChild("link") != null) {
            information.setLink(plannerElement.getChildText("link"));
        }
        if (plannerElement.getChild("description") != null) {
            information.setDescription(plannerElement.getChildText("description"));
        }
        Element platformElement = plannerElement.getChild("platform");
        EnumSet<EPlannerPlatform> platforms = EnumSet.noneOf(EPlannerPlatform.class);
        if (platformElement != null) {
            for (EPlannerPlatform platform : EPlannerPlatform.values()) {
                if (platformElement.getChild(platform.getXmlIdentifier()) == null) continue;
                platforms.add(platform);
            }
        }
        information.setSupportedPlatforms(platforms);
        Element requirementsElement = plannerElement.getChild("requirements");
        EnumSet<PDDLRequirement> requirements = EnumSet.noneOf(PDDLRequirement.class);
        if (requirementsElement != null) {
            for (PDDLRequirement requirement : PDDLRequirement.values()) {
                if (requirementsElement.getChild(requirement.getPddlName()) == null) continue;
                requirements.add(requirement);
            }
        }
        information.setSupportedRequirements(requirements);
        information.setSettings(this.readSettingsFromXML(plannerElement.getChild("settings")));
        return information;
    }

    public ItSimplePlannerSettings readSettingsFromXML(Element settingsElement) {
        Element argumentElement;
        Element outputElement;
        ItSimplePlannerSettings settings = new ItSimplePlannerSettings();
        if (settingsElement.getChild("filePath") != null) {
            settings.setExecutableFilePath(settingsElement.getChildText("filePath"));
        }
        if ((outputElement = settingsElement.getChild("output")) != null) {
            Element consoleOutputElement;
            if (outputElement.getAttributeValue("hasOutputFile").equals("true")) {
                settings.setHasOutputFile(true);
            } else {
                settings.setHasOutputFile(false);
            }
            Element outputFileElement = outputElement.getChild("outputFile");
            if (outputFileElement != null) {
                Element additionalFilesElement;
                Element autoIncrElement;
                if (outputFileElement.getChild("fileName") != null) {
                    settings.setOutputFile(outputFileElement.getChildText("fileName"));
                }
                if ((autoIncrElement = outputFileElement.getChild("fileNameAutomaticIncrement")) != null && !autoIncrElement.getText().isEmpty()) {
                    settings.setOutputFileAutomaticIncrementSuffix(autoIncrElement.getText());
                } else {
                    settings.setOutputFileAutomaticIncrementSuffix(null);
                }
                argumentElement = outputFileElement.getChild("argument");
                if (argumentElement != null) {
                    settings.setOutputFileNeedsArgument(argumentElement.getAttributeValue("needArgument").equals("true"));
                    settings.setOutputFileArgumentName(argumentElement.getAttributeValue("parameter"));
                }
                if ((additionalFilesElement = outputFileElement.getChild("additionalGeneratedFiles")) != null) {
                    for (Object addFile : additionalFilesElement.getChildren("fileName")) {
                        settings.addAdditionalGeneratedFile(((Element)addFile).getText());
                    }
                }
            }
            if ((consoleOutputElement = outputElement.getChild("consoleOutput")) != null) {
                Element planStartElement = consoleOutputElement.getChild("planStartIdentifier");
                settings.setConsoleOutputPlanStartIdentifier(planStartElement.getText());
                String startsAfterNLinesValue = planStartElement.getAttributeValue("startsAfterNlines", "0");
                if (!startsAfterNLinesValue.isEmpty()) {
                    settings.setConsoleOutputStartsAfterNLines(Integer.parseInt(startsAfterNLinesValue));
                }
                settings.setConsoleOutputPlanEndIdentifier(consoleOutputElement.getChildText("planEndIdentifier"));
            }
        }
        for (Object argument : settingsElement.getChild("arguments").getChildren()) {
            argumentElement = (Element)argument;
            if (argumentElement.getName().equals("domain")) {
                settings.setDomainArgumentName(argumentElement.getAttributeValue("parameter"));
                continue;
            }
            if (argumentElement.getName().equals("problem")) {
                settings.setProblemArgumentName(argumentElement.getAttributeValue("parameter"));
                continue;
            }
            if (!argumentElement.getName().equals("argument") || !argumentElement.getChildText("enable").equals("true")) continue;
            settings.addAdditionalArgument(new PlannerArgument(argumentElement.getAttributeValue("parameter"), argumentElement.getChildText("value")));
        }
        Element noPlanSignalElement = settingsElement.getChild("noPlanFoundSignal");
        if (noPlanSignalElement != null) {
            String type = noPlanSignalElement.getAttributeValue("type");
            if (type.equals("emptyPlan")) {
                settings.setNoPlanFoundSignalType(ENoPlanFoundSignalType.EMPTY_PLAN);
            } else if (type.equals("outputText")) {
                settings.setNoPlanFoundSignalType(ENoPlanFoundSignalType.OUTPUT_TEXT);
                settings.setNoPlanFoundOutputText(noPlanSignalElement.getText());
            } else if (type.equals("errorCode")) {
                settings.setNoPlanFoundSignalType(ENoPlanFoundSignalType.ERROR_CODE);
                settings.setNoPlanFoundErrorCode(Integer.parseInt(noPlanSignalElement.getText()));
            }
        } else {
            settings.setNoPlanFoundSignalType(ENoPlanFoundSignalType.EMPTY_PLAN);
        }
        return settings;
    }

    public boolean containsRequirements(Element plannerElement, Set<PDDLRequirement> domainRequirements) {
        return this.containsRequirements(this.readInformationFromXML(plannerElement), domainRequirements);
    }

    public boolean containsRequirements(ItSimplePlannerInformation info, Set<PDDLRequirement> domainRequirements) {
        return info.getSupportedRequirements().containsAll(domainRequirements);
    }

    public ItSimplePlannerInformation getPlannerByName(String name) {
        for (ItSimplePlannerInformation plannerInfo : this.getPlannersList()) {
            if (!plannerInfo.getName().equals(name) || !this.runsOnOperatingSystem(plannerInfo)) continue;
            return plannerInfo;
        }
        return null;
    }

    protected List<ItSimplePlannerInformation> getPlannersList() {
        ArrayList<ItSimplePlannerInformation> info = new ArrayList<ItSimplePlannerInformation>();
        for (Element plannerElement : this.plannersXml.getChild("planners").getChildren("planner")) {
            info.add(this.readInformationFromXML(plannerElement));
        }
        return info;
    }

    public final void preparePlanner(Element selectedPlanner) {
        this.preparePlanner(new File("."), selectedPlanner);
    }

    public final void preparePlanner(File plannersDirectory, Element selectedPlanner) {
        this.preparePlanner(plannersDirectory, this.readInformationFromXML(selectedPlanner));
    }

    public void preparePlanner(File plannersDirectory, ItSimplePlannerInformation selectedPlanner) {
    }

    public List<ItSimplePlannerInformation> suggestPlanners(PDDLRequirement ... requirements) {
        return this.suggestPlanners(EnumSet.copyOf(Arrays.asList(requirements)));
    }

    public List<ItSimplePlannerInformation> suggestPlanners(Set<PDDLRequirement> requirements) {
        ArrayList<ItSimplePlannerInformation> suggestedPlanners = new ArrayList<ItSimplePlannerInformation>();
        for (ItSimplePlannerInformation plannerInfo : this.getPlannersList()) {
            if (!this.containsRequirements(plannerInfo, requirements) || !this.runsOnOperatingSystem(plannerInfo)) continue;
            suggestedPlanners.add(plannerInfo);
        }
        return suggestedPlanners;
    }

    protected EPlannerPlatform getOperatingSystem() {
        return ItSimpleUtils.getOperatingSystem();
    }

    protected boolean runsOnOperatingSystem(ItSimplePlannerInformation plannerInfo) {
        return plannerInfo.getSupportedPlatforms().contains((Object)this.getOperatingSystem());
    }
}

