/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl.itsimple;

import cz.cuni.amis.planning4j.external.impl.itsimple.EPlannerPlatform;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlannerInformation;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimplePlanningException;
import cz.cuni.amis.planning4j.external.impl.itsimple.ItSimpleUtils;
import cz.cuni.amis.planning4j.external.impl.itsimple.SimplePlannerListManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.jdom.Element;

public class PlannerListManager
extends SimplePlannerListManager {
    private final Object fileOperationsMutex = new Object();

    public PlannerListManager(Element plannersXml) {
        super(plannersXml);
    }

    public final void extractAndPreparePlanner(ItSimplePlannerInformation selectedPlanner) {
        this.extractAndPreparePlanner(new File("."), selectedPlanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFileIfNotExists(File targetFile, String resourcePath) {
        Object object = this.fileOperationsMutex;
        synchronized (object) {
            if (!targetFile.exists()) {
                InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);
                if (inputStream == null) {
                    throw new ItSimplePlanningException("Could not find planner resource on classpath. Resource path:" + resourcePath);
                }
                if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                    throw new ItSimplePlanningException("Could not create parent dirs for planner resource " + targetFile);
                }
                try {
                    FileOutputStream outputfilestream = new FileOutputStream(targetFile);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputfilestream);
                    outputfilestream.close();
                }
                catch (IOException ex) {
                    throw new ItSimplePlanningException("Could not extract planner resource to " + targetFile, ex);
                }
            }
        }
    }

    public void extractAndPreparePlanner(File targetDirectory, ItSimplePlannerInformation selectedPlanner) {
        if (selectedPlanner == null) {
            throw new NullPointerException("Planner can't be null");
        }
        File binaryFile = ItSimpleUtils.getPlannerExecutableFile(targetDirectory, selectedPlanner);
        String plannerRelativeFileName = selectedPlanner.getSettings().getExecutableFilePath();
        String plannerResourcePath = "/" + plannerRelativeFileName;
        this.extractFileIfNotExists(binaryFile, plannerResourcePath);
        this.preparePlanner(targetDirectory, selectedPlanner);
    }

    @Override
    public void preparePlanner(File plannersDirectory, ItSimplePlannerInformation selectedPlanner) {
        super.preparePlanner(plannersDirectory, selectedPlanner);
        if (ItSimpleUtils.getOperatingSystem().equals((Object)EPlannerPlatform.LINUX)) {
            File plannerFile = ItSimpleUtils.getPlannerExecutableFile(plannersDirectory, selectedPlanner);
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "+x", plannerFile.getAbsolutePath()});
            }
            catch (IOException ex) {
                Logger.getLogger(PlannerListManager.class.getName()).log(Level.SEVERE, "Could not set planner file permissions", ex);
            }
        }
    }
}

