/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external.impl;

import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.PlanningException;
import cz.cuni.amis.planning4j.external.IExternalPlannerExecutor;
import cz.cuni.amis.planning4j.external.IExternalPlanningProcess;
import cz.cuni.amis.planning4j.external.IExternalPlanningResult;
import cz.cuni.amis.planning4j.impl.PlanFuture;
import cz.cuni.amis.utils.future.FutureStatus;
import java.io.File;

public abstract class AbstractExternalPlannerExecutor
implements IExternalPlannerExecutor {
    protected abstract IExternalPlanningProcess createProcess(File var1, File var2, long var3);

    @Override
    public IPlanFuture<IExternalPlanningResult> executePlanner(File domainFile, File problemFile, long timeSpentInIO) {
        final IExternalPlanningProcess planningProcess = this.createProcess(domainFile, problemFile, timeSpentInIO);
        final ExternalPlannerPlanFuture future = new ExternalPlannerPlanFuture(planningProcess);
        final ExternalPlannerShutdownHook shutdownHook = new ExternalPlannerShutdownHook(planningProcess);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    try {
                        IExternalPlanningResult planningResult = planningProcess.executePlanner();
                        PlanFuture planFuture = future;
                        synchronized (planFuture) {
                            if (!future.isCancelled()) {
                                if (planningResult != null) {
                                    future.setResult((Object)planningResult);
                                } else {
                                    future.cancel(true);
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (future.getStatus() == FutureStatus.FUTURE_IS_BEING_COMPUTED) {
                            future.computationException(ex);
                            break block12;
                        }
                        throw new PlanningException("Exception occurred in processing planning future result", (Throwable)ex);
                    }
                    finally {
                        Runtime.getRuntime().removeShutdownHook(shutdownHook);
                    }
                }
            }
        }, "ExternalPlanner").start();
        return future;
    }

    protected class ExternalPlannerShutdownHook
    extends Thread {
        private IExternalPlanningProcess planningProcess;

        public ExternalPlannerShutdownHook(IExternalPlanningProcess planningProcess) {
            this.planningProcess = planningProcess;
        }

        @Override
        public void run() {
            this.planningProcess.cancel();
        }
    }

    protected class ExternalPlannerPlanFuture
    extends PlanFuture<IExternalPlanningResult> {
        private IExternalPlanningProcess planningProcess;

        public ExternalPlannerPlanFuture(IExternalPlanningProcess planningProcess) {
            this.planningProcess = planningProcess;
        }

        protected boolean cancelComputation(boolean mayInterruptIfRunning) {
            if (mayInterruptIfRunning) {
                this.planningProcess.cancel();
                return true;
            }
            return super.cancelComputation(mayInterruptIfRunning);
        }
    }
}

