/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.external;

import cz.cuni.amis.planning4j.IDomainProvider;
import cz.cuni.amis.planning4j.IPDDLWriterDomainProvider;
import cz.cuni.amis.planning4j.IPDDLWriterProblemProvider;
import cz.cuni.amis.planning4j.IPlanFuture;
import cz.cuni.amis.planning4j.IProblemProvider;
import cz.cuni.amis.planning4j.PlanningIOException;
import cz.cuni.amis.planning4j.external.IExternalPlannerExecutor;
import cz.cuni.amis.planning4j.external.IExternalPlanningResult;
import cz.cuni.amis.planning4j.impl.AbstractAsyncPlanner;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ExternalPlanner
extends AbstractAsyncPlanner<IPDDLWriterDomainProvider, IPDDLWriterProblemProvider> {
    private IExternalPlannerExecutor externalPlannerExecutor;
    private File domainTempFile;
    private File problemTempFile;

    private static File silentCreateTempFile(String prefix, String suffix, File tempDirectory) {
        try {
            return File.createTempFile(prefix, suffix, tempDirectory);
        }
        catch (IOException ex) {
            throw new PlanningIOException(ex);
        }
    }

    public ExternalPlanner(IExternalPlannerExecutor externalPlannerExecutor) {
        this(externalPlannerExecutor, new File(System.getProperty("java.io.tmpdir")));
    }

    public ExternalPlanner(IExternalPlannerExecutor externalPlannerExecutor, File tempDirectory) {
        this(externalPlannerExecutor, ExternalPlanner.silentCreateTempFile("domain_", ".pddl", tempDirectory), ExternalPlanner.silentCreateTempFile("problem_", ".pddl", tempDirectory));
    }

    public ExternalPlanner(IExternalPlannerExecutor externalPlannerExecutor, File domainTempFile, File problemTempFile) {
        super(IPDDLWriterDomainProvider.class, IPDDLWriterProblemProvider.class);
        this.externalPlannerExecutor = externalPlannerExecutor;
        this.domainTempFile = domainTempFile;
        this.problemTempFile = problemTempFile;
    }

    public IExternalPlanningResult plan(IPDDLWriterDomainProvider domainProvider, IPDDLWriterProblemProvider problemProvider) {
        return (IExternalPlanningResult)super.plan((IDomainProvider)domainProvider, (IProblemProvider)problemProvider);
    }

    public IPlanFuture<IExternalPlanningResult> planAsync(IPDDLWriterDomainProvider domainProvider, IPDDLWriterProblemProvider problemProvider) {
        OutputStreamWriter domainFileWriter = null;
        OutputStreamWriter problemFileWriter = null;
        try {
            long start_time = System.currentTimeMillis();
            domainFileWriter = new FileWriter(this.domainTempFile);
            domainProvider.writeDomain((Writer)domainFileWriter);
            domainFileWriter.close();
            problemFileWriter = new FileWriter(this.problemTempFile);
            problemProvider.writeProblem((Writer)problemFileWriter);
            problemFileWriter.close();
            long io_time = System.currentTimeMillis() - start_time;
            return this.externalPlannerExecutor.executePlanner(this.domainTempFile, this.problemTempFile, io_time);
        }
        catch (IOException ex) {
            try {
                if (domainFileWriter != null) {
                    domainFileWriter.close();
                }
                if (problemFileWriter != null) {
                    problemFileWriter.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new PlanningIOException(ex);
        }
    }
}

