/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.io.Serializable;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Point2D;

public class Vector2D
implements Cloneable,
Serializable {
    protected double x = 1.0;
    protected double y = 0.0;

    public Vector2D() {
        this(1.0, 0.0);
    }

    public Vector2D(java.awt.geom.Point2D point) {
        this(point.getX(), point.getY());
    }

    public Vector2D(java.awt.geom.Point2D point1, java.awt.geom.Point2D point2) {
        this(point2.getX() - point1.getX(), point2.getY() - point1.getY());
    }

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Vector2D create(Point2D point) {
        return new Vector2D(point.getX(), point.getY());
    }

    public static Vector2D create(double x, double y) {
        return new Vector2D(x, y);
    }

    public static final Vector2D createPolar(double rho, double theta) {
        return new Vector2D(rho * Math.cos(theta), rho * Math.sin(theta));
    }

    public static final double dot(Vector2D v1, Vector2D v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY();
    }

    public static final double cross(Vector2D v1, Vector2D v2) {
        return v1.getX() * v2.getY() - v2.getX() * v1.getY();
    }

    public static final boolean isColinear(Vector2D v1, Vector2D v2) {
        v1 = v1.getNormalizedVector();
        v2 = v2.getNormalizedVector();
        return Math.abs(v1.getX() * v2.getY() - v1.getY() * v2.getX()) < 1.0E-12;
    }

    public static final boolean isOrthogonal(Vector2D v1, Vector2D v2) {
        v1 = v1.getNormalizedVector();
        v2 = v2.getNormalizedVector();
        return Math.abs(v1.getX() * v2.getX() + v1.getY() * v2.getY()) < 1.0E-12;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Deprecated
    public void setX(double x) {
        this.x = x;
    }

    @Deprecated
    public void setY(double y) {
        this.y = y;
    }

    @Deprecated
    public void setVector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Deprecated
    public void setAsPolar(double rho, double theta) {
        this.x = rho * Math.cos(theta);
        this.y = rho * Math.sin(theta);
    }

    public Vector2D getOpposite() {
        return new Vector2D(-this.x, -this.y);
    }

    public double getNorm() {
        return Math.hypot(this.x, this.y);
    }

    public double getAngle() {
        return Angle2D.getHorizontalAngle(this);
    }

    public void normalize() {
        double r = Math.hypot(this.x, this.y);
        this.x /= r;
        this.y /= r;
    }

    public Vector2D getNormalizedVector() {
        double r = Math.hypot(this.x, this.y);
        return new Vector2D(this.x / r, this.y / r);
    }

    public boolean isColinear(Vector2D v) {
        return Vector2D.isColinear(this, v);
    }

    public boolean isOrthogonal(Vector2D v) {
        return Vector2D.isOrthogonal(this, v);
    }

    public double dot(Vector2D v) {
        return this.x * v.getX() + this.y * v.getY();
    }

    public double cross(Vector2D v) {
        return this.x * v.getY() - v.getX() * this.y;
    }

    public Vector2D plus(Vector2D v) {
        return new Vector2D(this.x + v.getX(), this.y + v.getY());
    }

    public Vector2D minus(Vector2D v) {
        return new Vector2D(this.x - v.getX(), this.y - v.getY());
    }

    public Vector2D times(double k) {
        return new Vector2D(this.x * k, this.y * k);
    }

    public Vector2D transform(AffineTransform2D trans) {
        double[] tab = trans.getCoefficients();
        return new Vector2D(this.x * tab[0] + this.y * tab[1], this.x * tab[3] + this.y * tab[4]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector2D)) {
            return false;
        }
        Vector2D v = (Vector2D)obj;
        return Math.abs(v.getX() - this.x) < 1.0E-12 && Math.abs(v.getY() - this.y) < 1.0E-12;
    }

    public String toString() {
        return new String("Vector2D(" + this.x + ", " + this.y + ")");
    }

    public Vector2D clone() {
        return new Vector2D(this.x, this.y);
    }
}

