/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.dbg.view;

import cz.cuni.amis.dash.DashWindow;
import cz.cuni.amis.dash.YaposhEngine;
import cz.cuni.amis.pogamut.sposh.dbg.engine.EngineThread;
import cz.cuni.amis.pogamut.sposh.dbg.engine.EvaluationListener;
import cz.cuni.amis.pogamut.sposh.dbg.view.Bundle;
import cz.cuni.sposh.debugger.BreakpointManager;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="EngineSelectionComponent", persistenceType=0)
public final class EngineSelectionComponent
extends TopComponent {
    private final String SELECTION_BREAKPOINT_GROUP = "selection breakpoint group";
    private final BreakpointManager breakpointManager;
    private final JPDABreakpointListener engineWatcher;
    private final DefaultTreeModel treeModel;
    private final SessionsRoot sessionsRoot;
    private final MouseListener treeSelectionListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            Object lastComponent;
            int selRow = EngineSelectionComponent.this.jEnginesTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = EngineSelectionComponent.this.jEnginesTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 2 && (lastComponent = selPath.getLastPathComponent()) instanceof ThreadNode) {
                ThreadNode threadNode = (ThreadNode)lastComponent;
                this.openDebugger(threadNode.getThread());
            }
        }

        private void openDebugger(EngineThread engineThread) {
            assert (SwingUtilities.isEventDispatchThread());
            JPDADebugger debugger = engineThread.getDebugger();
            JPDAThread jpdaThread = engineThread.getThread();
            YaposhEngine engine = new YaposhEngine(new EngineThread(debugger, jpdaThread));
            DashWindow view = new DashWindow(engine, "Lap debugger");
            engine.addListener(view);
            engine.initialize();
            view.open();
            view.requestActive();
        }
    };
    private final DebuggerManagerListener removeSessionsListener = new DebuggerManagerAdapter(){

        public void sessionAdded(Session session) {
        }

        public void sessionRemoved(Session session) {
            SessionNode sessionNode = EngineSelectionComponent.this.sessionsRoot.getSessionNode(session);
            if (sessionNode != null) {
                EngineSelectionComponent.this.treeModel.removeNodeFromParent(sessionNode);
            }
        }
    };
    private JTree jEnginesTree;
    private JScrollPane jScrollPane;
    private JLabel lblInfo;

    public EngineSelectionComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_EngineSelectionComponent());
        this.setToolTipText(Bundle.HINT_EngineSelectionComponent());
        this.sessionsRoot = new SessionsRoot();
        this.treeModel = new DefaultTreeModel(this.sessionsRoot);
        this.jEnginesTree.getSelectionModel().setSelectionMode(1);
        this.jEnginesTree.addMouseListener(this.treeSelectionListener);
        this.jEnginesTree.setModel(this.treeModel);
        this.breakpointManager = BreakpointManager.createLapEvaluation("selection breakpoint group");
        this.breakpointManager.purge();
        this.engineWatcher = new EngineWatcher(this.treeModel, this.sessionsRoot);
        this.breakpointManager.addListener(this.engineWatcher);
    }

    private void initComponents() {
        this.lblInfo = new JLabel();
        this.jScrollPane = new JScrollPane();
        this.jEnginesTree = new JTree();
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.lblInfo.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.lblInfo, (String)NbBundle.getMessage(EngineSelectionComponent.class, (String)"EngineSelectionComponent.lblInfo.text"));
        this.lblInfo.setVerticalAlignment(1);
        this.add(this.lblInfo);
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("root");
        this.jEnginesTree.setModel(new DefaultTreeModel(treeNode1));
        this.jScrollPane.setViewportView(this.jEnginesTree);
        this.add(this.jScrollPane);
    }

    public void componentOpened() {
        this.breakpointManager.addListener(this.engineWatcher);
        DebuggerManager.getDebuggerManager().addDebuggerListener(this.removeSessionsListener);
    }

    public void componentClosed() {
        DebuggerManager.getDebuggerManager().removeDebuggerListener(this.removeSessionsListener);
        this.breakpointManager.removeListener(this.engineWatcher);
        this.breakpointManager.purge();
    }

    static final class ThreadNode
    extends AbstractTreeNode<Object, DefaultMutableTreeNode> {
        public ThreadNode(EngineThread userObject) {
            super(userObject, false);
        }

        public EngineThread getThread() {
            return (EngineThread)this.getUserObject();
        }

        @Override
        public String toString() {
            return this.getThread().getName();
        }
    }

    static final class SessionNode
    extends AbstractTreeNode<EngineThread, ThreadNode> {
        public SessionNode(Session session) {
            super(session, true);
        }

        public Session getSession() {
            return (Session)this.getUserObject();
        }

        public ThreadNode getThreadNode(EngineThread thread) {
            return (ThreadNode)this.getChild(thread);
        }

        public int getInsertPosition(EngineThread thread) {
            assert (this.getThreadNode(thread) == null);
            int insertPosition = this.getChildPosition(thread, thread);
            return insertPosition;
        }

        @Override
        public String toString() {
            return this.getSession().getName();
        }
    }

    static final class SessionsRoot
    extends AbstractTreeNode<Session, SessionNode> {
        SessionsRoot() {
        }

        public SessionNode getSessionNode(Session session) {
            return (SessionNode)this.getChild(session);
        }

        public int getInsertPosition(Session session) {
            assert (this.getSessionNode(session) == null);
            Comparator<Session> sessionComparator = new Comparator<Session>(){

                @Override
                public int compare(Session o1, Session o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            int sessionInsertPosition = this.getChildPosition(session, sessionComparator);
            return sessionInsertPosition;
        }

        @Override
        public String toString() {
            return "Running sessions";
        }
    }

    static class AbstractTreeNode<CHILD_OBJECT, CHILD_NODE extends DefaultMutableTreeNode>
    extends DefaultMutableTreeNode {
        protected AbstractTreeNode() {
        }

        protected AbstractTreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
        }

        public final DefaultMutableTreeNode getChild(CHILD_OBJECT userObject) {
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e.nextElement();
                Object childUserObject = childNode.getUserObject();
                if (!childUserObject.equals(userObject)) continue;
                return childNode;
            }
            return null;
        }

        public final int getChildPosition(CHILD_OBJECT newChildObject, Comparator<CHILD_OBJECT> comparator) {
            DefaultMutableTreeNode childNode;
            Object childObject;
            int childNodePosition = 0;
            Enumeration<TreeNode> e = this.children();
            while (e.hasMoreElements() && comparator.compare(childObject = (childNode = (DefaultMutableTreeNode)e.nextElement()).getUserObject(), newChildObject) < 0) {
                ++childNodePosition;
            }
            return childNodePosition;
        }
    }

    private static class EngineWatcher
    extends EvaluationListener {
        private final DefaultTreeModel treeModel;
        private final SessionsRoot sessionsRoot;

        EngineWatcher(DefaultTreeModel treeModel, SessionsRoot sessionsRoot) {
            assert (sessionsRoot.getChildCount() == 0);
            this.treeModel = treeModel;
            this.sessionsRoot = sessionsRoot;
        }

        public void breakpointReached(JPDABreakpointEvent breakpointEvent) {
            EngineThread engineThread;
            ThreadNode threadNode;
            JPDADebugger debugger = breakpointEvent.getDebugger();
            Session session = EngineWatcher.getSession(debugger);
            SessionNode sessionNode = this.sessionsRoot.getSessionNode(session);
            if (sessionNode == null) {
                int sessionPosition = this.sessionsRoot.getInsertPosition(session);
                sessionNode = new SessionNode(session);
                this.treeModel.insertNodeInto(sessionNode, this.sessionsRoot, sessionPosition);
            }
            if ((threadNode = sessionNode.getThreadNode(engineThread = new EngineThread(debugger, breakpointEvent.getThread()))) == null) {
                int threadInsertPosition = sessionNode.getInsertPosition(engineThread);
                threadNode = new ThreadNode(engineThread);
                this.treeModel.insertNodeInto(threadNode, sessionNode, threadInsertPosition);
            }
        }
    }
}

