/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.dbg.engine;

import com.sun.jdi.AbsentInformationException;
import java.util.Comparator;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;

public class EngineThread
implements Comparable<EngineThread>,
Comparator<EngineThread> {
    private static final String ENGINE_THREAD_NAME_SUFFIX = " logic";
    private final JPDADebugger debugger;
    private final JPDAThread engineThread;

    public EngineThread(JPDADebugger debugger, JPDAThread engineThread) {
        assert (engineThread.getName().endsWith(ENGINE_THREAD_NAME_SUFFIX));
        this.debugger = debugger;
        this.engineThread = engineThread;
    }

    public final JPDAThread getThread() {
        return this.engineThread;
    }

    public final JPDADebugger getDebugger() {
        return this.debugger;
    }

    public final String getName() {
        String name = this.engineThread.getName();
        int suffixLength = ENGINE_THREAD_NAME_SUFFIX.length();
        int threadNameLength = name.length() - suffixLength;
        return name.substring(0, threadNameLength);
    }

    public This getThisVariable() throws AbsentInformationException {
        CallStackFrame frame = this.engineThread.getCallStack()[0];
        This thisVar = frame.getThisVariable();
        return thisVar;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EngineThread other = (EngineThread)obj;
        return this.engineThread == other.engineThread || this.engineThread != null && this.engineThread.equals(other.engineThread);
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this.engineThread != null ? this.engineThread.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(EngineThread other) {
        if (this.equals(other.engineThread)) {
            return 0;
        }
        return this.getName().compareTo(other.getName());
    }

    @Override
    public int compare(EngineThread o1, EngineThread o2) {
        return o1.compareTo(o2);
    }

    static EngineThread createBreakpointThread(JPDABreakpointEvent jpdabe) {
        return new EngineThread(jpdabe.getDebugger(), jpdabe.getThread());
    }
}

