/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.dash;

import cz.cuni.amis.pogamut.sposh.dbg.engine.IDebugEngine;
import cz.cuni.amis.pogamut.sposh.dbg.exceptions.UnexpectedMessageException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;

public final class ServerManager {
    private static final Map<InetSocketAddress, PausedConnection> pausedServers = new HashMap<InetSocketAddress, PausedConnection>();
    private static final String PAUSE_COMMAND = "PAUSE {PauseAll True}";
    private static final String RESUME_COMMAND = "PAUSE {PauseAll False}";

    void connect() {
    }

    void disconnect() {
    }

    public static synchronized void pause(IDebugEngine blockingEngine, InetSocketAddress serverAddress) throws IOException, UnexpectedMessageException {
        assert (serverAddress != null);
        PausedConnection pausedConnection = pausedServers.get(serverAddress);
        if (pausedConnection == null) {
            pausedConnection = PausedConnection.create(blockingEngine, serverAddress);
            pausedServers.put(serverAddress, pausedConnection);
        }
        pausedConnection.sendTextCommand(PAUSE_COMMAND);
    }

    public static synchronized void resume(IDebugEngine resumingEngine, InetSocketAddress serverAddress) throws IOException {
        assert (serverAddress != null);
        if (pausedServers.containsKey(serverAddress)) {
            PausedConnection frozenConnection = pausedServers.get(serverAddress);
            if (frozenConnection.blocingEngines.contains(resumingEngine)) {
                frozenConnection.blocingEngines.remove(resumingEngine);
            }
            if (frozenConnection.blocingEngines.isEmpty()) {
                frozenConnection.sendTextCommand(RESUME_COMMAND);
                frozenConnection.close();
                pausedServers.remove(serverAddress);
            }
        }
    }

    public static synchronized void clear(IDebugEngine engine) throws IOException {
        HashSet<InetSocketAddress> nonblockedPausedServers = new HashSet<InetSocketAddress>();
        for (Map.Entry<InetSocketAddress, PausedConnection> pausedServer : pausedServers.entrySet()) {
            PausedConnection pausedConnection = pausedServer.getValue();
            if (pausedConnection.blocingEngines.contains(engine)) {
                pausedConnection.blocingEngines.remove(engine);
            }
            if (!pausedConnection.blocingEngines.isEmpty()) continue;
            nonblockedPausedServers.add(pausedServer.getKey());
        }
        for (InetSocketAddress nonblockedPausedServer : nonblockedPausedServers) {
            pausedServers.remove(nonblockedPausedServer);
        }
    }

    private static class PausedConnection {
        public final Set<IDebugEngine> blocingEngines = new HashSet<IDebugEngine>();
        public final Socket socket;
        private static final int HANDSHAKE_MESSAGE_LIMIT = 100000;
        private static final int CLOSE_CONTROL_CONNECTION_DELAY_MS = 3000;

        private PausedConnection(IDebugEngine initialBlockingEngine, Socket socket) {
            this.blocingEngines.add(initialBlockingEngine);
            this.socket = socket;
        }

        public void sendTextCommand(String command) throws IOException {
            PrintWriter serverWriter = new PrintWriter(this.socket.getOutputStream());
            serverWriter.println(command);
            serverWriter.flush();
        }

        public static PausedConnection create(IDebugEngine freezingEngine, InetSocketAddress serverAddress) throws IOException, UnexpectedMessageException {
            Socket socket = new Socket();
            socket.connect(serverAddress);
            BufferedReader socketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PausedConnection.recieveMessage(socketReader, "HELLO_CONTROL_SERVER");
            PrintWriter socketWriter = new PrintWriter(socket.getOutputStream());
            PausedConnection.sendCommand(socketWriter, "READY");
            PausedConnection.recieveHandshake(socketReader);
            return new PausedConnection(freezingEngine, socket);
        }

        private static void recieveHandshake(BufferedReader reader) throws IOException, UnexpectedMessageException {
            String message;
            PausedConnection.recieveMessage(reader, "SHS");
            int messageCount = 0;
            do {
                message = reader.readLine();
                if (++messageCount <= 100000) continue;
                throw new UnexpectedMessageException("Handshake over limit 100000");
            } while (!message.equals("EHS"));
        }

        private static String recieveMessage(BufferedReader reader, String expectedMessage) throws IOException, UnexpectedMessageException {
            String recievedMessage = reader.readLine();
            if (!recievedMessage.equals(expectedMessage)) {
                throw new UnexpectedMessageException(recievedMessage, expectedMessage);
            }
            return recievedMessage;
        }

        private static void sendCommand(PrintWriter writer, String command) {
            writer.println(command);
            writer.flush();
        }

        public void close() {
            Thread closeConnectionThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        PausedConnection.this.socket.close();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            };
            closeConnectionThread.start();
        }
    }
}

