/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pathfinding.alg.floydwarshall;

import cz.cuni.amis.pathfinding.Maze;
import cz.cuni.amis.pathfinding.MazeNode;
import cz.cuni.amis.pathfinding.alg.floydwarshall.FloydWarshall;
import cz.cuni.amis.pathfinding.map.IPFKnownMap;
import cz.cuni.amis.tests.BaseTest;
import java.util.List;
import java.util.Random;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test01_FloydWarshall
extends BaseTest {
    static Maze maze;
    static FloydWarshall<MazeNode> fw;
    Random random = new Random(System.currentTimeMillis());

    @BeforeClass
    public static void before() {
        String mazeImage = "/cz/cuni/amis/pathfinding/maze-small.bmp";
        log.info("Loading image " + mazeImage);
        maze = new Maze(mazeImage);
        log.info("Maze loaded...");
        fw = new FloydWarshall((IPFKnownMap)maze, log);
    }

    private void test(int num, int startX, int startY, int endX, int endY, boolean expectedSuccess) {
        log.info("TEST " + num + " / 42");
        log.info("" + (expectedSuccess ? "POSITIVE TEST" : "NEGATIVE TEST"));
        log.info("Start: " + startX + "," + startY);
        log.info("End: " + endX + ", " + endY);
        MazeNode start = Test01_FloydWarshall.maze.nodes[startX][startY];
        MazeNode end = Test01_FloydWarshall.maze.nodes[endX][endY];
        if (expectedSuccess && !start.isFree()) {
            log.info("Start[" + startX + "," + startY + "] is not a free point!");
            throw new RuntimeException("Start[" + startX + "," + startY + "] is not a free point!");
        }
        if (expectedSuccess && !end.isFree()) {
            log.info("Start[" + endX + ", " + endY + "] is not a free point!");
            throw new RuntimeException("Start[" + endX + ", " + endY + "] is not a free point!");
        }
        List path = fw.getPath((Object)start, (Object)end);
        if (expectedSuccess && path == null) {
            this.testFailed("Path not found! Can't be! Either someone passed wrong maze.png or AStar has failed!");
        }
        if (!expectedSuccess && path != null) {
            this.testFailed("Path found! Should not exist!");
        }
        if (path != null) {
            log.info("Path found!");
            log.info("Path length: " + path.size());
            maze.output(path, "FW", num);
        } else {
            log.info("Path does not exist! (Expected == correct)");
        }
        this.testOk();
    }

    private MazeNode getRandomNode(boolean free) {
        int x = this.random.nextInt(Test01_FloydWarshall.maze.width);
        int y = this.random.nextInt(Test01_FloydWarshall.maze.height);
        while (free != Test01_FloydWarshall.maze.maze[x][y]) {
            x = this.random.nextInt(Test01_FloydWarshall.maze.width);
            y = this.random.nextInt(Test01_FloydWarshall.maze.height);
        }
        return Test01_FloydWarshall.maze.nodes[x][y];
    }

    private void testPositiveRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(true);
        while (start == goal) {
            goal = this.getRandomNode(true);
        }
        this.test(num, start.x, start.y, goal.x, goal.y, true);
    }

    private void testNegativeRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(false);
        while (start == goal) {
            goal = this.getRandomNode(false);
        }
        this.test(num, start.x, start.y, goal.x, goal.y, false);
    }

    @Test
    public void test1() {
        this.test(1, 0, 0, 1, Test01_FloydWarshall.maze.height - 2, true);
    }

    @Test
    public void test2() {
        this.test(2, 0, 2, 1, Test01_FloydWarshall.maze.height - 2, true);
    }

    @Test
    public void test2PositiveRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testPositiveRandom(5 + i);
        }
    }

    @Test
    public void test3NegativeRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testNegativeRandom(25 + i);
        }
    }
}

