/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pathfinding.alg.astar;

import cz.cuni.amis.pathfinding.Maze;
import cz.cuni.amis.pathfinding.MazeNode;
import cz.cuni.amis.pathfinding.alg.astar.AStar;
import cz.cuni.amis.pathfinding.alg.astar.AStarResult;
import cz.cuni.amis.pathfinding.map.IPFGoal;
import cz.cuni.amis.pathfinding.map.IPFMap;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.heap.IHeap;
import java.util.Random;
import java.util.Set;
import org.junit.BeforeClass;
import org.junit.Test;

public class Test02_AStar
extends BaseTest {
    static Maze maze;
    Random random = new Random(System.currentTimeMillis());

    @BeforeClass
    public static void before() {
        String mazeImage = "/cz/cuni/amis/pathfinding/maze.bmp";
        log.info("Loading image " + mazeImage);
        maze = new Maze(mazeImage);
        log.info("Maze loaded...");
    }

    private void test(int num, int startX, int startY, int endX, int endY, boolean expectedSuccess) {
        log.info("TEST " + num + " / 44");
        log.info("" + (expectedSuccess ? "POSITIVE TEST" : "NEGATIVE TEST"));
        log.info("Start: " + startX + "," + startY);
        log.info("End: " + endX + ", " + endY);
        MazeNode start = Test02_AStar.maze.nodes[startX][startY];
        MazeNode end = Test02_AStar.maze.nodes[endX][endY];
        if (expectedSuccess && !start.isFree()) {
            this.testFailed("Start[" + startX + "," + startY + "] is not a free point!");
            throw new RuntimeException("[ERROR] Start[" + startX + "," + startY + "] is not a free point!");
        }
        if (expectedSuccess && !end.isFree()) {
            this.testFailed("Start[" + endX + ", " + endY + "] is not a free point!");
            throw new RuntimeException("[ERROR] Start[" + endX + ", " + endY + "] is not a free point!");
        }
        log.info("Invoking AStar!");
        StopWatch watch = new StopWatch();
        AStar aStar = new AStar((IPFMap)maze);
        AStarResult result = aStar.findPath((IPFGoal)new MazeGoal(start, end), 0L);
        log.info("AStar time:  " + watch.stopStr() + " ms");
        if (expectedSuccess != result.isSuccess()) {
            if (!result.isSuccess()) {
                this.testFailed("Path not found! Can't be! Either someone passed wrong maze.png or AStar has failed!");
                throw new RuntimeException("Path not found! Can't be! Either someone passed wrong maze.png or AStar has failed!");
            }
            this.testFailed("Path found! Should not exist!");
            throw new RuntimeException("Path found! Should not exist!");
        }
        if (result.isSuccess()) {
            log.info("Path found!");
            log.info("Path length: " + result.getPath().size());
            maze.output(result.getPath(), "AStar", num);
        } else {
            log.info("Path does not exist! (Expected == correct)");
        }
        this.testOk();
    }

    private MazeNode getRandomNode(boolean free) {
        int x = this.random.nextInt(Test02_AStar.maze.width);
        int y = this.random.nextInt(Test02_AStar.maze.height);
        while (free != Test02_AStar.maze.maze[x][y]) {
            x = this.random.nextInt(Test02_AStar.maze.width);
            y = this.random.nextInt(Test02_AStar.maze.height);
        }
        return Test02_AStar.maze.nodes[x][y];
    }

    private void testPositiveRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(true);
        this.test(num, start.x, start.y, goal.x, goal.y, true);
    }

    private void testNegativeRandom(int num) {
        MazeNode start = this.getRandomNode(true);
        MazeNode goal = this.getRandomNode(false);
        this.test(num, start.x, start.y, goal.x, goal.y, false);
    }

    @Test
    public void test1() {
        this.test(1, 1, 1, Test02_AStar.maze.width - 1, Test02_AStar.maze.height - 2, true);
    }

    @Test
    public void test2() {
        this.test(2, 1, Test02_AStar.maze.height - 2, Test02_AStar.maze.width - 1, Test02_AStar.maze.height - 2, true);
    }

    @Test
    public void test3() {
        this.test(3, 1, Test02_AStar.maze.height - 2, Test02_AStar.maze.width - 2, 1, true);
    }

    @Test
    public void test4Same() {
        this.test(4, 1, 1, 1, 1, true);
    }

    @Test
    public void test5PositiveRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testPositiveRandom(5 + i);
        }
    }

    @Test
    public void test6NegativeRandom() {
        for (int i = 0; i < 20; ++i) {
            this.testNegativeRandom(25 + i);
        }
    }

    public class MazeGoal
    implements IPFGoal<MazeNode> {
        private MazeNode goal;
        private MazeNode start;

        public MazeGoal(MazeNode start, MazeNode goal) {
            this.start = start;
            this.goal = goal;
        }

        public int getEstimatedCostToGoal(MazeNode node) {
            int dX = this.goal.x - node.x;
            int dY = this.goal.y - node.y;
            return (int)Math.sqrt(dX * dX + dY * dY);
        }

        public MazeNode getStart() {
            return this.start;
        }

        public boolean isGoalReached(MazeNode actualNode) {
            return this.goal.equals(actualNode);
        }

        public void setCloseList(Set<MazeNode> closedList) {
        }

        public void setOpenList(IHeap<MazeNode> openList) {
        }
    }
}

