/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pathfinding;

import cz.cuni.amis.pathfinding.MazeNode;
import cz.cuni.amis.pathfinding.map.IPFKnownMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.imageio.ImageIO;

public class Maze
implements IPFKnownMap<MazeNode> {
    public boolean[][] maze = null;
    public MazeNode[][] nodes = null;
    public int width;
    public int height;
    private BufferedImage image;
    private File imageFile;
    int black = this.getRGB(0, 0, 0);
    int red = this.getRGB(255, 0, 0);
    int green = this.getRGB(0, 255, 0);
    int blue = this.getRGB(100, 100, 255);
    int white = this.getRGB(255, 255, 255);

    public Maze(String pathToResource) {
        int j;
        int i;
        URI uri;
        Class<?> cls = this.getClass();
        URL url = this.getClass().getResource(pathToResource);
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not obrain URI from URL: " + url.toString());
        }
        this.imageFile = new File(uri);
        if (!this.imageFile.exists()) {
            throw new RuntimeException("File as resource (" + pathToResource + ") does not exist at: " + this.imageFile.getAbsolutePath());
        }
        try {
            this.image = ImageIO.read(this.imageFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read image from: " + this.imageFile.getAbsolutePath());
        }
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.maze = new boolean[this.width][];
        this.nodes = new MazeNode[this.width][];
        for (i = 0; i < this.width; ++i) {
            this.maze[i] = new boolean[this.image.getHeight()];
            this.nodes[i] = new MazeNode[this.image.getHeight()];
            for (j = 0; j < this.height; ++j) {
                int pixel = this.image.getRGB(i, j);
                int alpha = pixel >> 24 & 0xFF;
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                this.maze[i][j] = red != 0;
                this.nodes[i][j] = new MazeNode(this, i, j);
            }
        }
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                if (i > 0 && this.maze[i - 1][j]) {
                    this.nodes[i][j].neighs.add(this.nodes[i - 1][j]);
                }
                if (i < this.width - 1 && this.maze[i + 1][j]) {
                    this.nodes[i][j].neighs.add(this.nodes[i + 1][j]);
                }
                if (j > 0 && this.maze[i][j - 1]) {
                    this.nodes[i][j].neighs.add(this.nodes[i][j - 1]);
                }
                if (j >= this.height - 1 || !this.maze[i][j + 1]) continue;
                this.nodes[i][j].neighs.add(this.nodes[i][j + 1]);
            }
        }
    }

    public int getArcCost(MazeNode nodeFrom, MazeNode nodeTo) {
        return Math.abs(nodeFrom.x - nodeTo.x) + Math.abs(nodeFrom.y - nodeTo.y);
    }

    public Collection<MazeNode> getNeighbors(MazeNode node) {
        return node.neighs;
    }

    public int getRGB(int r, int g, int b) {
        int pixel = 0;
        pixel = 255;
        pixel = pixel << 8 | r;
        pixel = pixel << 8 | g;
        pixel = pixel << 8 | b;
        return pixel;
    }

    private void setPixel(int x, int y, int rgb) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            this.image.setRGB(x, y, rgb);
        }
    }

    private void restorePixel(int x, int y) {
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            if (this.maze[x][y]) {
                this.image.setRGB(x, y, this.white);
            } else {
                this.image.setRGB(x, y, this.black);
            }
        }
    }

    private void rectangle(int x, int y, int rgb) {
        for (int i = x - 4; i < x + 4; ++i) {
            for (int j = y - 4; j < y + 4; ++j) {
                this.setPixel(i, j, rgb);
            }
        }
    }

    private void restoreRectangle(int x, int y) {
        for (int i = x - 4; i < x + 4; ++i) {
            for (int j = y - 4; j < y + 4; ++j) {
                this.restorePixel(i, j);
            }
        }
    }

    public void output(List<MazeNode> result, String name, int number) {
        MazeNode start = result.get(0);
        MazeNode end = result.get(result.size() - 1);
        int r = 100;
        int g = 100;
        int b = 100;
        int i = 0;
        for (MazeNode node : result) {
            if (++i % 10 == 0) {
                if (++r == 256) {
                    g += 10;
                    r = 100;
                }
                if (g >= 256) {
                    b += 10;
                    g = 100;
                }
                if (b >= 256) {
                    b = 100;
                }
            }
            this.image.setRGB(node.x, node.y, this.getRGB(r, g, b));
        }
        this.rectangle(start.x, start.y, this.red);
        this.rectangle(end.x, end.y, this.green);
        String separ = System.getProperty("file.separator");
        String imagePath = this.imageFile.getAbsolutePath();
        File out = new File(imagePath.substring(0, imagePath.lastIndexOf(separ)) + separ + "maze-result-" + name + "-" + (number > 9 ? Integer.valueOf(number) : "0" + number) + ".bmp");
        try {
            ImageIO.write((RenderedImage)this.image, "bmp", out);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write BMP output with maze-result into " + out.getAbsolutePath(), e);
        }
        System.out.println("[INFO] result saved into " + out.getAbsolutePath());
        this.restoreRectangle(start.x, start.y);
        this.restoreRectangle(end.x, end.y);
        for (MazeNode node : result) {
            this.image.setRGB(node.x, node.y, this.white);
        }
    }

    public List<MazeNode> getNodes() {
        ArrayList<MazeNode> nodesList = new ArrayList<MazeNode>(this.width * this.height);
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (!this.maze[i][j]) continue;
                nodesList.add(this.nodes[i][j]);
            }
        }
        return nodesList;
    }

    public int getNodeCost(MazeNode node) {
        return 0;
    }
}

