/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.experiments.impl.metrics;

import cz.cuni.amis.experiments.impl.metrics.AbstractMetric;

public class TimeMeasuringMetric
extends AbstractMetric {
    private long timeConsumed = 0L;
    private long unaccountedPeriodStart = 0L;
    private int numRunningInstances = 0;
    private boolean countEachInstanceSeparately;

    public TimeMeasuringMetric(String name) {
        this(name, true);
    }

    public TimeMeasuringMetric(String name, boolean countEachInstanceSeparately) {
        super(name);
        this.countEachInstanceSeparately = countEachInstanceSeparately;
    }

    public synchronized void taskStarted() {
        if (!this.active) {
            return;
        }
        this.accountLastPeriod();
        ++this.numRunningInstances;
    }

    private void accountLastPeriod() {
        long currentTime = System.currentTimeMillis();
        if (this.numRunningInstances > 0) {
            long currentPeriodLength = currentTime - this.unaccountedPeriodStart;
            this.timeConsumed = this.countEachInstanceSeparately ? (this.timeConsumed += currentPeriodLength * (long)this.numRunningInstances) : (this.timeConsumed += currentPeriodLength);
        }
        this.unaccountedPeriodStart = currentTime;
    }

    public synchronized void taskFinished() {
        if (!this.active) {
            return;
        }
        if (this.numRunningInstances <= 0) {
            throw new IllegalStateException("Cannot finish a task that has not started. Task:" + this.getName());
        }
        this.accountLastPeriod();
        --this.numRunningInstances;
    }

    @Override
    public synchronized Long getValue() {
        if (this.active) {
            this.accountLastPeriod();
        }
        return this.timeConsumed;
    }

    @Override
    public void stopMeasurement() {
        if (!this.active) {
            return;
        }
        this.accountLastPeriod();
        this.numRunningInstances = 0;
        super.stopMeasurement();
    }
}

