/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.FunctionAddressResolver;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import com.jogamp.opengl.GLRendererQuirks;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDebugListener;
import javax.media.opengl.GLDebugMessage;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPipelineFactory;
import javax.media.opengl.GLProfile;
import jogamp.opengl.ExtensionAvailabilityCache;
import jogamp.opengl.GLBufferSizeTracker;
import jogamp.opengl.GLBufferStateTracker;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.GLDebugMessageHandler;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.GLStateTracker;
import jogamp.opengl.GLVersionNumber;

public abstract class GLContextImpl
extends GLContext {
    private String contextFQN;
    private int additionalCtxCreationFlags;
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private String glRenderer;
    private String glRendererLowerCase;
    private String glVersion;
    private GLBufferSizeTracker bufferSizeTracker;
    private final GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private final GLStateTracker glStateTracker = new GLStateTracker();
    private GLDebugMessageHandler glDebugHandler = null;
    private final int[] boundFBOTarget = new int[]{0, 0};
    private int defaultVAO = 0;
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected static final Object mappedContextTypeObjectLock = new Object();
    protected static final HashMap<String, ExtensionAvailabilityCache> mappedExtensionAvailabilityCache = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLProcAddress = new HashMap();
    protected static final HashMap<String, ProcAddressTable> mappedGLXProcAddress = new HashMap();

    public static void shutdownImpl() {
        mappedExtensionAvailabilityCache.clear();
        mappedGLProcAddress.clear();
        mappedGLXProcAddress.clear();
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.synchronizeBufferObjectSharing(gLContext, this);
        this.drawable = gLDrawableImpl;
        if (null != gLDrawableImpl) {
            gLDrawableImpl.associateContext(this, true);
        }
        this.drawableRead = gLDrawableImpl;
        this.glDebugHandler = new GLDebugMessageHandler(this);
    }

    @Override
    protected void resetStates() {
        if (this.bufferSizeTracker != null) {
            this.bufferSizeTracker.clearCachedBufferSizes();
        }
        if (this.bufferStateTracker != null) {
            this.bufferStateTracker.clearBufferObjectState();
        }
        if (this.glStateTracker != null) {
            this.glStateTracker.clearStates(false);
        }
        this.extensionAvailability = null;
        this.glProcAddressTable = null;
        this.gl = null;
        this.contextFQN = null;
        this.additionalCtxCreationFlags = 0;
        this.glRendererLowerCase = this.glRenderer = "";
        if (this.boundFBOTarget != null) {
            this.boundFBOTarget[0] = 0;
            this.boundFBOTarget[1] = 0;
        }
        super.resetStates();
    }

    @Override
    public final GLDrawable setGLReadDrawable(GLDrawable gLDrawable) {
        if (!this.isGLReadDrawableAvailable()) {
            throw new GLException("Setting read drawable feature not available");
        }
        boolean bl = this.lock.isOwner(Thread.currentThread());
        if (bl) {
            this.release();
        } else if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread (" + this.lock.getOwner() + "), operation not allowed.");
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead;
        GLDrawableImpl gLDrawableImpl2 = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLReadDrawable() {
        return this.drawableRead;
    }

    @Override
    public final GLDrawable setGLDrawable(GLDrawable gLDrawable, boolean bl) {
        if (null == gLDrawable) {
            throw new GLException("Null read/write drawable not allowed");
        }
        boolean bl2 = this.lock.isOwner(Thread.currentThread());
        if (bl2) {
            this.release();
        } else if (this.lock.isLockedByOtherThread()) {
            throw new GLException("GLContext current by other thread (" + this.lock.getOwner() + "), operation not allowed.");
        }
        if (!bl || this.drawableRead == this.drawable) {
            this.drawableRead = (GLDrawableImpl)gLDrawable;
        }
        GLDrawableImpl gLDrawableImpl = this.drawable;
        gLDrawableImpl.associateContext(this, false);
        this.drawableRetargeted = null != this.drawable;
        this.drawable = (GLDrawableImpl)gLDrawable;
        this.drawable.associateContext(this, true);
        if (bl2) {
            this.makeCurrent();
        }
        return gLDrawableImpl;
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public final GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    @Override
    public final GL getGL() {
        return this.gl;
    }

    @Override
    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().getSimpleName() + ", " + this.gl.toString() : "<null>";
            String string2 = null != gL ? gL.getClass().getSimpleName() + ", " + gL.toString() : "<null>";
            Exception exception = new Exception("Info: setGL (OpenGL " + this.getGLVersion() + "): " + Thread.currentThread().getName() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    protected void drawableUpdatedNotify() throws GLException {
    }

    public abstract Object getPlatformGLExtensions();

    @Override
    public void release() throws GLException {
        this.release(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(boolean bl) throws GLException {
        boolean bl2;
        Throwable throwable;
        block12: {
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - release() - force: " + bl + ", " + this.lock);
            }
            if (!this.lock.isOwner(Thread.currentThread())) {
                throw new GLException("Context not current on current thread " + Thread.currentThread().getName() + ": " + this);
            }
            throwable = null;
            bl2 = (bl || this.lock.getHoldCount() == 1) && 0L != this.contextHandle;
            try {
                if (bl2) {
                    if (!bl) {
                        try {
                            this.contextMadeCurrent(false);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                        }
                    }
                    this.releaseImpl();
                }
                if (!bl2) break block12;
            }
            catch (Throwable throwable3) {
                if (bl2) {
                    GLContextImpl.setCurrent(null);
                }
                this.drawable.unlockSurface();
                this.lock.unlock();
                if (TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - " + (bl2 ? "switch" : "keep  ") + " - CONTEXT_RELEASE - " + this.lock);
                }
                throw throwable3;
            }
            GLContextImpl.setCurrent(null);
        }
        this.drawable.unlockSurface();
        this.lock.unlock();
        if (TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - " + (bl2 ? "switch" : "keep  ") + " - CONTEXT_RELEASE - " + this.lock);
        }
        if (null != throwable) {
            throw new GLException("GLContext.release(false) during GLDrawableImpl.contextMadeCurrent(this, false)", throwable);
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        if (DEBUG || TRACE_SWITCH) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.0: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
        }
        if (this.contextHandle != 0L) {
            int n = this.drawable.lockSurface();
            if (1 == n) {
                throw new GLException("Surface not ready to lock: " + this.drawable);
            }
            Throwable throwable = null;
            try {
                Object object;
                this.lock.lock();
                if (this.lock.getHoldCount() > 2) {
                    object = GLContextImpl.getThreadName() + ": GLContextImpl.destroy: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle);
                    if (DEBUG || TRACE_SWITCH) {
                        System.err.println((String)object + " - Lock was hold more than once - makeCurrent/release imbalance: " + this.lock);
                        Thread.dumpStack();
                    }
                    if (this.lock.getHoldCount() > 3) {
                        throw new GLException((String)object + " - Lock was hold more than twice - makeCurrent/release imbalance: " + this.lock);
                    }
                }
                try {
                    if (this.lock.getHoldCount() == 1) {
                        this.makeCurrent();
                    }
                    try {
                        this.contextRealized(false);
                        this.drawable.associateContext(this, false);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (0 != this.defaultVAO) {
                        object = new int[]{this.defaultVAO};
                        this.gl.getGL2GL3().glBindVertexArray(0);
                        this.gl.getGL2GL3().glDeleteVertexArrays(1, (int[])object, 0);
                        this.defaultVAO = 0;
                    }
                    this.glDebugHandler.enable(false);
                    if (this.lock.getHoldCount() > 1) {
                        this.release(true);
                    }
                    this.destroyImpl();
                    this.contextHandle = 0L;
                    this.glDebugHandler = null;
                    if (GLContextShareSet.contextDestroyed(this) && !GLContextShareSet.hasCreatedSharedLeft(this)) {
                        GLContextShareSet.unregisterSharing(this);
                    }
                }
                finally {
                    this.lock.unlock();
                    if (TRACE_SWITCH) {
                        System.err.println(GLContextImpl.getThreadName() + ": GLContextImpl.destroy.X: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", isShared " + GLContextShareSet.isShared(this) + " - " + this.lock);
                    }
                }
            }
            finally {
                this.drawable.unlockSurface();
            }
            if (null != throwable) {
                throw new GLException("GLContext.destroy() during GLDrawableImpl.contextRealized(this, false)", throwable);
            }
        }
        this.resetStates();
    }

    protected abstract void destroyImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void copy(GLContext gLContext, int n) throws GLException {
        if (gLContext.getHandle() == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (this.getHandle() == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        int n2 = this.drawable.lockSurface();
        if (1 == n2) {
            throw new GLException("Surface not ready to lock");
        }
        try {
            this.copyImpl(gLContext, n);
        }
        finally {
            this.drawable.unlockSurface();
        }
    }

    protected abstract void copyImpl(GLContext var1, int var2) throws GLException;

    @Override
    public int makeCurrent() throws GLException {
        boolean bl = false;
        int n = 0;
        int n2 = this.drawable.lockSurface();
        if (1 >= n2) {
            return 0;
        }
        try {
            if (2 == n2) {
                this.drawable.updateHandle();
            }
            this.lock.lock();
            try {
                GLContext gLContext = GLContextImpl.getCurrent();
                if (gLContext != null) {
                    if (gLContext == this) {
                        this.drawableUpdatedNotify();
                        if (TRACE_SWITCH) {
                            System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - keep   - CONTEXT_CURRENT - " + this.lock);
                        }
                        int n3 = 1;
                        return n3;
                    }
                    gLContext.release();
                }
                if (0L == this.drawable.getHandle()) {
                    throw new GLException("drawable has invalid handle: " + this.drawable);
                }
                n = this.makeCurrentWithinLock(n2);
                bl = 0 == n;
            }
            catch (RuntimeException runtimeException) {
                bl = true;
                throw runtimeException;
            }
            finally {
                if (bl) {
                    this.lock.unlock();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            bl = true;
            throw runtimeException;
        }
        finally {
            if (bl) {
                this.drawable.unlockSurface();
            }
        }
        if (n == 0) {
            if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - switch - CONTEXT_NOT_CURRENT - " + this.lock);
            }
        } else {
            GLContextImpl.setCurrent(this);
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
                this.glDebugHandler.init(this.isGL2GL3() && this.isGLDebugEnabled());
                if (DEBUG_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Debug", null, this.gl, null));
                    if (this.glDebugHandler.isEnabled()) {
                        this.glDebugHandler.addListener(new GLDebugMessageHandler.StdErrGLDebugListener(true));
                    }
                }
                if (TRACE_GL) {
                    this.gl = this.gl.getContext().setGL(GLPipelineFactory.create("javax.media.opengl.Trace", null, this.gl, new Object[]{System.err}));
                }
                this.contextRealized(true);
                if (DEBUG || TRACE_SWITCH) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - switch - CONTEXT_CURRENT_NEW - " + this.lock);
                }
            } else if (TRACE_SWITCH) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.ContextSwitch: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " - switch - CONTEXT_CURRENT - " + this.lock);
            }
            this.contextMadeCurrent(true);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int makeCurrentWithinLock(int n) throws GLException {
        if (!this.isCreated()) {
            Object object;
            boolean bl;
            GLContextImpl gLContextImpl;
            if (DEBUG_GL) {
                this.additionalCtxCreationFlags |= 0x20;
            }
            if (null != (gLContextImpl = (GLContextImpl)GLContextShareSet.getShareContext(this))) {
                gLContextImpl.getDrawableImpl().lockSurface();
            }
            try {
                bl = this.createImpl(gLContextImpl);
                if (bl && this.isGL3core() && (this.ctxMajorVersion > 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion >= 2)) {
                    object = new int[1];
                    this.gl.getGL2GL3().glGenVertexArrays(1, (int[])object, 0);
                    this.defaultVAO = (int)object[0];
                    this.gl.getGL2GL3().glBindVertexArray(this.defaultVAO);
                }
            }
            finally {
                if (null != gLContextImpl) {
                    gLContextImpl.getDrawableImpl().unlockSurface();
                }
            }
            if (DEBUG || TRACE_SWITCH) {
                if (bl) {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context OK: obj " + GLContextImpl.toHexString(this.hashCode()) + ", ctx " + GLContextImpl.toHexString(this.contextHandle) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " for " + this.getClass().getName() + " - " + this.getGLVersion());
                } else {
                    System.err.println(GLContextImpl.getThreadName() + ": Create GL context FAILED obj " + GLContextImpl.toHexString(this.hashCode()) + ", surf " + GLContextImpl.toHexString(this.drawable.getHandle()) + " for " + this.getClass().getName());
                }
            }
            if (!bl) {
                return 0;
            }
            object = this.drawable.getNativeSurface().getGraphicsConfiguration();
            AbstractGraphicsDevice abstractGraphicsDevice = object.getScreen().getDevice();
            if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && 0 == (this.ctxOptions & 8)) {
                int n2 = this.ctxMajorVersion < 3 || this.ctxMajorVersion == 3 && this.ctxMinorVersion == 0 ? 2 : this.ctxMajorVersion;
                int n3 = 0 != (this.ctxOptions & 4) ? 4 : 2;
                GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n2, n3, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextOLD-MapVersionsAvailable HAVE: " + abstractGraphicsDevice + " -> " + n2 + "." + n3 + " -> " + this.getGLVersion());
                }
            }
            GLContextShareSet.contextCreated(this);
            return 2;
        }
        this.makeCurrentImpl();
        return 1;
    }

    protected abstract void makeCurrentImpl() throws GLException;

    protected void contextRealized(boolean bl) {
        this.drawable.contextRealized(this, bl);
    }

    protected void contextMadeCurrent(boolean bl) {
        this.drawable.contextMadeCurrent(this, bl);
    }

    protected abstract boolean createImpl(GLContextImpl var1) throws GLException;

    protected abstract long createContextARBImpl(long var1, boolean var3, int var4, int var5, int var6);

    protected abstract void destroyContextARBImpl(long var1);

    protected final long createContextARB(long l, boolean bl) {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": createContextARB: mappedVersionsAvailableSet(" + abstractGraphicsDevice.getConnection() + "): " + GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice));
        }
        if (!GLContext.getAvailableGLVersionsSet(abstractGraphicsDevice) && !this.mapGLVersions(abstractGraphicsDevice)) {
            return 0L;
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        int[] nArray = new int[]{0, 0};
        GLContextImpl.getRequestMajorAndCompat(gLCapabilitiesImmutable.getGLProfile(), nArray);
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        long l2 = 0L;
        if (GLContext.getAvailableGLVersion(abstractGraphicsDevice, nArray[0], nArray[1], nArray2, nArray3, nArray4)) {
            nArray4[0] = nArray4[0] | this.additionalCtxCreationFlags;
            l2 = this.createContextARBImpl(l, bl, nArray4[0], nArray2[0], nArray3[0]);
            if (0L != l2) {
                this.setGLFunctionAvailability(true, nArray2[0], nArray3[0], nArray4[0]);
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean mapGLVersions(AbstractGraphicsDevice abstractGraphicsDevice) {
        HashMap<String, Integer> hashMap = GLContext.deviceVersionAvailable;
        synchronized (hashMap) {
            long l = DEBUG ? System.nanoTime() : 0L;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl2) {
                bl2 = this.createContextARBMapVersionsAvailable(4, 2);
                bl |= bl2;
                if (bl2) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 2, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 4, 4, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    if (PROFILE_ALIASING) {
                        bl3 = true;
                        bl4 = true;
                        bl5 = true;
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl3) {
                bl3 = this.createContextARBMapVersionsAvailable(3, 2);
                bl |= bl3;
                if (bl3) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 2, 2, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    if (PROFILE_ALIASING) {
                        bl4 = true;
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl4) {
                bl4 = this.createContextARBMapVersionsAvailable(2, 2);
                bl |= bl4;
                if (bl4) {
                    this.resetStates();
                }
            }
            if (!bl5) {
                bl5 = this.createContextARBMapVersionsAvailable(4, 4);
                bl |= bl5;
                if (bl5) {
                    GLContext.mapAvailableGLVersion(abstractGraphicsDevice, 3, 4, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
                    if (PROFILE_ALIASING) {
                        bl6 = true;
                    }
                    this.resetStates();
                }
            }
            if (!bl6) {
                bl6 = this.createContextARBMapVersionsAvailable(3, 4);
                bl |= bl6;
                if (bl6) {
                    this.resetStates();
                }
            }
            if (bl) {
                GLContext.setAvailableGLVersionsSet(abstractGraphicsDevice);
                if (DEBUG) {
                    long l2 = System.nanoTime();
                    System.err.println("GLContextImpl.mapGLVersions: " + abstractGraphicsDevice + ", profileAliasing: " + PROFILE_ALIASING + ", total " + (double)(l2 - l) / 1000000.0 + "ms");
                    System.err.println(GLContext.dumpAvailableGLVersions(null).toString());
                }
            } else if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersions NONE for :" + abstractGraphicsDevice);
            }
            return bl;
        }
    }

    private final boolean createContextARBMapVersionsAvailable(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        n7 = 2 == n2 ? (n7 |= 2) : (n7 |= 4);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (4 == n) {
            n6 = 4;
            n5 = GLContext.getMaxMinor(n6);
            n4 = 4;
            n3 = 0;
        } else if (3 == n) {
            n6 = 3;
            n5 = GLContext.getMaxMinor(n6);
            n4 = 3;
            n3 = 1;
        } else {
            n6 = 3;
            n5 = 0;
            n4 = 2;
            n3 = 0;
        }
        long l = this.createContextARBVersions(0L, true, n7, n6, n5, n4, n3, nArray, nArray2);
        if (0L == l && 4 == n2) {
            n7 &= 0xFFFFFFFB;
            l = this.createContextARBVersions(0L, true, n7 |= 0x10, n6, n5, n4, n3, nArray, nArray2);
            if (0L == l) {
                n7 &= 0xFFFFFFFB;
                n7 &= 0xFFFFFFEF;
                l = this.createContextARBVersions(0L, true, n7 |= 2, n6, n5, n4, n3, nArray, nArray2);
            }
        }
        if (0L != l) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            GLContext.mapAvailableGLVersion(abstractGraphicsDevice, n, n2, this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions);
            this.destroyContextARBImpl(l);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable HAVE: " + n + "." + n2 + " -> " + this.getGLVersion());
            }
            bl = true;
        } else {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARB-MapVersionsAvailable NOPE: " + n + "." + n2);
            }
            bl = false;
        }
        return bl;
    }

    private final long createContextARBVersions(long l, boolean bl, int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        nArray[0] = n2;
        nArray2[0] = n3;
        long l2 = 0L;
        boolean bl2 = false;
        while (!bl2 && GLContext.isValidGLVersion(nArray[0], nArray2[0]) && (nArray[0] > n4 || nArray[0] == n4 && nArray2[0] >= n5)) {
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: share " + l + ", direct " + bl + ", version " + nArray[0] + "." + nArray2[0]);
            }
            if (0L != (l2 = this.createContextARBImpl(l, bl, n, nArray[0], nArray2[0]))) {
                bl2 = true;
                this.setGLFunctionAvailability(true, nArray[0], nArray2[0], n);
            } else {
                bl2 = false;
            }
            if (bl2 && nArray[0] >= 3) {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                this.gl.glGetIntegerv(33307, nArray3, 0);
                this.gl.glGetIntegerv(33308, nArray4, 0);
                boolean bl3 = bl2 = nArray3[0] > nArray[0] || nArray3[0] == nArray[0] && nArray4[0] >= nArray2[0];
                if (!bl2) {
                    this.removeCachedVersion(nArray[0], nArray2[0], n);
                    this.destroyContextARBImpl(l2);
                    l2 = 0L;
                }
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": createContextARBVersions: version verification - expected " + nArray[0] + "." + nArray2[0] + ", has " + nArray3[0] + "." + nArray4[0] + " == " + bl2);
                }
            }
            if (bl2 || GLContext.decrementGLVersion(nArray, nArray2)) continue;
            break;
        }
        return l2;
    }

    private final void setContextVersion(int n, int n2, int n3, boolean bl) {
        if (0 == n3) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        if (!GLContext.isValidGLVersion(n, n2)) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3));
        }
        this.ctxMajorVersion = n;
        this.ctxMinorVersion = n2;
        this.ctxOptions = n3;
        if (bl) {
            Object object;
            this.ctxVersionString = GLContextImpl.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, this.gl.glGetString(7938));
            this.ctxGLSLVersion = null;
            if (this.ctxMajorVersion >= 2 && null != (object = this.gl.glGetString(35724))) {
                this.ctxGLSLVersion = new VersionNumber((String)object, ".");
                if (this.ctxGLSLVersion.getMajor() < 1) {
                    this.ctxGLSLVersion = null;
                }
            }
            if (null == this.ctxGLSLVersion) {
                object = new int[2];
                GLContextImpl.getStaticGLSLVersionNumber(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, (int[])object);
                this.ctxGLSLVersion = new VersionNumber((int)object[0], (int)object[1], 0);
            }
        }
    }

    private static final VersionNumber getGLVersionNumber(int n, String string) {
        GLVersionNumber gLVersionNumber;
        if (null != string && (gLVersionNumber = new GLVersionNumber(string)).isValid()) {
            int n2 = gLVersionNumber.getMajor();
            int n3 = gLVersionNumber.getMinor();
            if (0 == (n & 1) && (n2 > 3 || n2 == 3 && n3 >= 1)) {
                n2 = 3;
                n3 = 0;
            }
            if (GLContext.isValidGLVersion(n2, n3)) {
                return new VersionNumber(n2, n3, 0);
            }
        }
        return null;
    }

    private Object createInstance(GLProfile gLProfile, String string, Class<?>[] classArray, Object[] objectArray) {
        return ReflectionUtil.createInstance((String)(gLProfile.getGLImplBaseClassName() + string), (Class[])classArray, (Object[])objectArray, (ClassLoader)this.getClass().getClassLoader());
    }

    private boolean verifyInstance(GLProfile gLProfile, String string, Object object) {
        return ReflectionUtil.instanceOf((Object)object, (String)(gLProfile.getGLImplBaseClassName() + string));
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public void bindPbufferToTexture() {
        throw new GLException("not implemented");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("not implemented");
    }

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    protected final String mapToRealGLFunctionName(String string) {
        String string2;
        Map<String, String> map = this.getFunctionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getFunctionNameMap();

    protected final String mapToRealGLExtensionName(String string) {
        String string2;
        Map<String, String> map = this.getExtensionNameMap();
        String string3 = string2 = null != map ? map.get(string) : null;
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected abstract Map<String, String> getExtensionNameMap();

    protected final void resetProcAddressTable(ProcAddressTable procAddressTable) {
        procAddressTable.reset((DynamicLookupHelper)this.getDrawableImpl().getGLDynamicLookupHelper());
    }

    private final boolean initGLRendererAndGLVersionStrings() {
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        long l = gLDynamicLookupHelper.dynamicLookupFunction("glGetString");
        if (0L == l) {
            System.err.println("Warning: Entry point to 'glGetString' is NULL.");
            if (DEBUG) {
                Thread.dumpStack();
            }
            return false;
        }
        String string = GLContextImpl.glGetStringInt(7937, l);
        if (null == string) {
            if (DEBUG) {
                System.err.println("Warning: GL_RENDERER is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glRenderer = string;
        this.glRendererLowerCase = this.glRenderer.toLowerCase();
        String string2 = GLContextImpl.glGetStringInt(7938, l);
        if (null == string2) {
            if (DEBUG) {
                System.err.println("Warning: GL_VERSION is NULL.");
                Thread.dumpStack();
            }
            return false;
        }
        this.glVersion = string2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setGLFunctionAvailability(boolean bl, int n, int n2, int n3) {
        VersionNumber versionNumber;
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return;
        }
        if (null == this.gl || !this.verifyInstance(this.gl.getGLProfile(), "Impl", this.gl)) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLXProcAddressTable();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        boolean bl2 = this.initGLRendererAndGLVersionStrings();
        if (DEBUG) {
            if (!bl2) {
                System.err.println("Warning: setGLFunctionAvailability: intialization of GL renderer strings failed. " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, null));
            } else {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail: Given " + abstractGraphicsDevice + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion));
            }
        }
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        VersionNumber versionNumber2 = new VersionNumber(n, n2, 0);
        Object object = GLContextImpl.getGLVersionNumber(n3, this.glVersion);
        if (null != object && (object.compareTo(versionNumber2) <= 0 || 0 == n)) {
            versionNumber = object;
            n = versionNumber.getMajor();
            n2 = versionNumber.getMinor();
        } else {
            versionNumber = versionNumber2;
        }
        if (!GLContext.isValidGLVersion(n, n2)) {
            throw new GLException("Invalid GL Version " + n + "." + n2 + ", ctp " + GLContextImpl.toHexString(n3) + ", " + this.glVersion + ", " + versionNumber);
        }
        if (2 > n) {
            n3 &= 0xFFFFFEFF;
        }
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.0 validated FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, this.glVersion) + ", " + versionNumber);
        }
        versionNumber2 = null;
        object = mappedContextTypeObjectLock;
        synchronized (object) {
            versionNumber2 = mappedGLProcAddress.get(this.contextFQN);
            if (null != versionNumber2 && !this.verifyInstance(this.gl.getGLProfile(), "ProcAddressTable", versionNumber2)) {
                throw new InternalError("GLContext GL ProcAddressTable mapped key(" + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null) + ") -> " + versionNumber2.getClass().getName() + " not matching " + this.gl.getGLProfile().getGLImplBaseClassName());
            }
        }
        if (null != versionNumber2) {
            this.glProcAddressTable = versionNumber2;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(versionNumber2.hashCode()));
            }
        } else {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[]{FunctionAddressResolver.class}, new Object[]{new GLProcAddressResolver()});
            this.resetProcAddressTable(this.getGLProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLProcAddress.put(this.contextFQN, this.getGLProcAddressTable());
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.getGLProcAddressTable().hashCode()));
                }
            }
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.get(this.contextFQN);
        }
        if (null != object) {
            this.extensionAvailability = object;
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache reusing key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(object.hashCode()) + " - entries: " + ((ExtensionAvailabilityCache)object).getTotalExtensionCount());
            }
        } else {
            this.extensionAvailability = new ExtensionAvailabilityCache();
            this.setContextVersion(n, n2, n3, false);
            this.extensionAvailability.reset(this);
            object2 = mappedContextTypeObjectLock;
            synchronized (object2) {
                mappedExtensionAvailabilityCache.put(this.contextFQN, this.extensionAvailability);
                if (DEBUG) {
                    System.err.println(GLContextImpl.getThreadName() + ": GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + GLContextImpl.toHexString(this.extensionAvailability.hashCode()) + " - entries: " + this.extensionAvailability.getTotalExtensionCount());
                }
            }
        }
        if (0 != (8 & n3) && n >= 2 || this.isExtensionAvailable("GL_ARB_ES2_compatibility")) {
            n3 |= 0x100;
            n3 |= 0x200;
        } else if (GLContextImpl.hasFBOImpl(n, n3, this.extensionAvailability)) {
            n3 |= 0x200;
        }
        if (FORCE_NO_FBO_SUPPORT) {
            n3 &= 0xFFFFFDFF;
        }
        this.setContextVersion(n, n2, n3, true);
        this.setRendererQuirks(0 == (n3 & 0x8000));
        this.setDefaultSwapInterval();
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": GLContext.setGLFuncAvail.X: " + this.contextFQN + " - " + GLContext.getGLVersion(this.ctxMajorVersion, this.ctxMinorVersion, this.ctxOptions, null));
        }
    }

    private final void setRendererQuirks(boolean bl) {
        int[] nArray = new int[6];
        int n = 0;
        if (Platform.getOSType() == Platform.OSType.MACOS) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(3) + ": cause: OS " + Platform.getOSType());
            }
            nArray[n++] = 3;
        } else if (Platform.getOSType() == Platform.OSType.WINDOWS) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(1) + ": cause: OS " + Platform.getOSType());
            }
            nArray[n++] = 1;
        }
        if (Platform.OSType.ANDROID == Platform.getOSType() && this.glRendererLowerCase.contains("powervr")) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(2) + ": cause: OS " + Platform.getOSType() + " / Renderer " + this.glRenderer);
            }
            nArray[n++] = 2;
        }
        if (this.glRendererLowerCase.contains("mesa") || this.glRendererLowerCase.contains("gallium")) {
            if (DEBUG) {
                System.err.println("Quirk: " + GLRendererQuirks.toString(4) + ": cause: Renderer " + this.glRenderer);
            }
            nArray[n++] = 4;
            if (bl) {
                if (DEBUG) {
                    System.err.println("Quirk: " + GLRendererQuirks.toString(0) + ": cause: Renderer " + this.glRenderer);
                }
                nArray[n++] = 0;
            }
        }
        this.glRendererQuirks = new GLRendererQuirks(nArray, 0, n);
    }

    private static final boolean hasFBOImpl(int n, int n2, ExtensionAvailabilityCache extensionAvailabilityCache) {
        return 0 != (n2 & 8) && n >= 2 || n >= 3 || null != extensionAvailabilityCache && extensionAvailabilityCache.isExtensionAvailable("GL_ARB_ES2_compatibility") || extensionAvailabilityCache.isExtensionAvailable("GL_ARB_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_EXT_framebuffer_object") || extensionAvailabilityCache.isExtensionAvailable("GL_OES_framebuffer_object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeCachedVersion(int n, int n2, int n3) {
        Object object;
        if (!this.isCurrentContextHardwareRasterizer()) {
            n3 |= 0x8000;
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        this.contextFQN = GLContextImpl.getContextFQN(abstractGraphicsDevice, n, n2, n3);
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": RM Context FQN: " + this.contextFQN + " - " + GLContext.getGLVersion(n, n2, n3, null));
        }
        Object object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedGLProcAddress.remove(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ProcAddressTable mapping key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
        object2 = mappedContextTypeObjectLock;
        synchronized (object2) {
            object = mappedExtensionAvailabilityCache.remove(this.contextFQN);
            if (DEBUG) {
                System.err.println(GLContextImpl.getThreadName() + ": RM GLContext GL ExtensionAvailabilityCache mapping key(" + this.contextFQN + ") -> " + object.hashCode());
            }
        }
    }

    private final boolean isCurrentContextHardwareRasterizer() {
        boolean bl = true;
        bl = !this.drawable.getChosenGLCapabilities().getHardwareAccelerated() ? false : !this.glRendererLowerCase.contains("software") && !this.glRendererLowerCase.contains("mesa x11") && !this.glRendererLowerCase.contains("softpipe") && !this.glRendererLowerCase.contains("llvmpipe");
        return bl;
    }

    protected abstract void updateGLXProcAddressTable();

    protected abstract StringBuilder getPlatformExtensionsStringImpl();

    @Override
    public final boolean isFunctionAvailable(String string) {
        ProcAddressTable procAddressTable;
        if (null != this.glProcAddressTable) {
            try {
                if (0L != this.glProcAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null != (procAddressTable = this.getPlatformExtProcAddressTable())) {
            try {
                if (0L != procAddressTable.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GLDynamicLookupHelper gLDynamicLookupHelper = this.getDrawableImpl().getGLDynamicLookupHelper();
        String string2 = GLNameResolver.normalizeVEN(GLNameResolver.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLNameResolver.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLNameResolver.getFuncNamePermutation(string2, i);
            try {
                l = gLDynamicLookupHelper.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
        }
        return false;
    }

    @Override
    public final int getPlatformExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getPlatformExtensionCount() : 0;
    }

    @Override
    public final String getPlatformExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getPlatformExtensionsString();
        }
        return null;
    }

    @Override
    public final int getGLExtensionCount() {
        return null != this.extensionAvailability ? this.extensionAvailability.getGLExtensionCount() : 0;
    }

    @Override
    public final String getGLExtensionsString() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.getGLExtensionsString();
        }
        return null;
    }

    public final boolean isExtensionCacheInitialized() {
        if (null != this.extensionAvailability) {
            return this.extensionAvailability.isInitialized();
        }
        return false;
    }

    protected static String getContextFQN(AbstractGraphicsDevice abstractGraphicsDevice, int n, int n2, int n3) {
        return abstractGraphicsDevice.getUniqueID() + "-" + GLContextImpl.toHexString(GLContextImpl.composeBits(n, n2, n3 &= 0xFFFFFCFF));
    }

    protected String getContextFQN() {
        return this.contextFQN;
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public boolean hasWaiters() {
        return this.lock.getQueueLength() > 0;
    }

    public final void setBoundFramebuffer(int n, int n2) {
        if (0 > n2) {
            return;
        }
        switch (n) {
            case 36160: {
                this.boundFBOTarget[0] = n2;
                this.boundFBOTarget[1] = n2;
                break;
            }
            case 36009: {
                this.boundFBOTarget[0] = n2;
                break;
            }
            case 36008: {
                this.boundFBOTarget[1] = n2;
                break;
            }
        }
    }

    @Override
    public final int getBoundFramebuffer(int n) {
        switch (n) {
            case 36009: 
            case 36160: {
                return this.boundFBOTarget[0];
            }
            case 36008: {
                return this.boundFBOTarget[1];
            }
        }
        throw new InternalError("Invalid FBO target name: " + GLContextImpl.toHexString(n));
    }

    @Override
    public final int getDefaultDrawFramebuffer() {
        return this.drawable.getDefaultDrawFramebuffer();
    }

    @Override
    public final int getDefaultReadFramebuffer() {
        return this.drawable.getDefaultReadFramebuffer();
    }

    @Override
    public final String getGLDebugMessageExtension() {
        return this.glDebugHandler.getExtension();
    }

    @Override
    public final boolean isGLDebugMessageEnabled() {
        return this.glDebugHandler.isEnabled();
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final void setContextCreationFlags(int n) {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = n & 0x20;
        }
    }

    @Override
    public final boolean isGLDebugSynchronous() {
        return this.glDebugHandler.isSynchronous();
    }

    @Override
    public final void setGLDebugSynchronous(boolean bl) {
        this.glDebugHandler.setSynchronous(bl);
    }

    @Override
    public final void enableGLDebugMessage(boolean bl) throws GLException {
        if (!this.isCreated()) {
            this.additionalCtxCreationFlags = bl ? (this.additionalCtxCreationFlags |= 0x20) : (this.additionalCtxCreationFlags &= 0xFFFFFFDF);
        } else if (0 != (this.additionalCtxCreationFlags & 0x20) && null != this.getGLDebugMessageExtension()) {
            this.glDebugHandler.enable(bl);
        }
    }

    @Override
    public final void addGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.addListener(gLDebugListener);
    }

    @Override
    public final void removeGLDebugListener(GLDebugListener gLDebugListener) {
        this.glDebugHandler.removeListener(gLDebugListener);
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, IntBuffer intBuffer, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, intBuffer, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, intBuffer, bl);
        }
    }

    @Override
    public final void glDebugMessageControl(int n, int n2, int n3, int n4, int[] nArray, int n5, boolean bl) {
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageControlARB(n, n2, n3, n4, nArray, n5, bl);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageEnableAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n3, n4, nArray, n5, bl);
        }
    }

    @Override
    public final void glDebugMessageInsert(int n, int n2, int n3, int n4, String string) {
        int n5;
        int n6 = n5 = null != string ? string.length() : 0;
        if (this.glDebugHandler.isExtensionARB()) {
            this.gl.getGL2GL3().glDebugMessageInsertARB(n, n2, n3, n4, n5, string);
        } else if (this.glDebugHandler.isExtensionAMD()) {
            this.gl.getGL2GL3().glDebugMessageInsertAMD(GLDebugMessage.translateARB2AMDCategory(n, n2), n4, n3, n5, string);
        }
    }

    protected static native String glGetStringInt(int var0, long var1);
}

