/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@XStreamAlias(value="substitution")
public class Substitution {
    @XStreamAlias(value="match")
    private String reMatch;
    @XStreamAlias(value="replace")
    private String reSubst;
    @XStreamAlias(value="multiLine")
    private Boolean multiLine;
    @XStreamAlias(value="caseSensitive")
    private Boolean caseSensitive;
    @XStreamOmitField
    private transient Pattern pattern;

    public Substitution() {
    }

    public Substitution(String reMatch, String reSubst, boolean caseSensitive, boolean multiLine) {
        this.reMatch = reMatch;
        this.reSubst = reSubst;
        this.caseSensitive = caseSensitive;
        this.multiLine = multiLine;
    }

    private Substitution readResolve() {
        if (this.caseSensitive == null) {
            this.caseSensitive = true;
        }
        if (this.multiLine == null) {
            this.multiLine = false;
        }
        return this;
    }

    public String getReMatch() {
        return this.reMatch;
    }

    public void setReMatch(String reMatch) {
        this.reMatch = reMatch;
        this.pattern = null;
    }

    public String getReSubst() {
        return this.reSubst;
    }

    public void setReSubst(String reSubst) {
        this.reSubst = reSubst;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.reMatch, (this.caseSensitive != false ? 0 : 2) | (this.multiLine != false ? 0 : 8));
        }
        return this.pattern;
    }

    public Matcher getMatcher(String str) {
        return this.getPattern().matcher(str);
    }

    public String substitute(String str) {
        return this.getMatcher(str).replaceAll(this.reSubst);
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return "Substitution[" + (this.caseSensitive != false ? "case-sensitive" : "case-INsensitive") + ", " + (this.multiLine != false ? "multi-line pattern" : "single-line pattern") + " | " + this.reMatch + " --> " + this.reSubst + "]";
    }
}

