/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.io.FileUtils;

@XStreamAlias(value="fixLineEndings")
public class FixLineEndings {
    @XStreamAlias(value="windowsStyle")
    @XStreamAsAttribute
    private Boolean windowsStyle = true;
    @XStreamAlias(value="onlyIfRewritten")
    @XStreamAsAttribute
    private Boolean fixOnlyIfRewritten = true;

    public FixLineEndings() {
    }

    public FixLineEndings(boolean windows) {
        this.windowsStyle = windows;
    }

    private FixLineEndings readResolve() {
        if (this.windowsStyle == null) {
            this.windowsStyle = true;
        }
        if (this.fixOnlyIfRewritten == null) {
            this.fixOnlyIfRewritten = true;
        }
        return this;
    }

    public boolean isFixOnlyIfRewritten() {
        if (this.fixOnlyIfRewritten == null) {
            return true;
        }
        return this.fixOnlyIfRewritten;
    }

    public Boolean getFixOnlyIfRewritten() {
        return this.fixOnlyIfRewritten;
    }

    public void setFixOnlyIfRewritten(Boolean fixOnlyIfRewritten) {
        this.fixOnlyIfRewritten = fixOnlyIfRewritten;
    }

    public boolean isWindowsStyle() {
        if (this.windowsStyle == null) {
            return true;
        }
        return this.windowsStyle;
    }

    public Boolean getWindowsStyle() {
        return this.windowsStyle;
    }

    public void setWindowsStyle(Boolean windowsStyle) {
        this.windowsStyle = windowsStyle;
    }

    public boolean fix(File in, File out) {
        BufferedReader reader = null;
        PrintWriter writer = null;
        try {
            reader = new BufferedReader(new FileReader(in));
            try {
                try {
                    writer = new PrintWriter(new FileWriter(out));
                    try {
                        try {
                            while (reader.ready()) {
                                String line = reader.readLine();
                                writer.print(line);
                                if (this.windowsStyle.booleanValue()) {
                                    writer.print('\r');
                                    writer.print('\n');
                                    continue;
                                }
                                writer.print('\n');
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Failed to rewrite file " + in.getAbsolutePath() + " into file " + out.getAbsolutePath() + ", because: " + e.getMessage(), e);
                        }
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to open file for writing: " + out.getAbsolutePath() + " because: " + e.getMessage(), e);
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to open file for reading: " + in.getAbsolutePath() + " because: " + e.getMessage(), e);
        }
        return true;
    }

    public synchronized boolean fix(File file) throws IOException {
        File tempFile = new File("temp.line-endings.txt");
        if (this.fix(file, tempFile)) {
            file.delete();
            FileUtils.moveFile((File)tempFile, (File)file);
            tempFile.delete();
            return true;
        }
        tempFile.delete();
        return false;
    }

    public String toString() {
        return "FixLineEndings[windowsStyle=" + this.isWindowsStyle() + ", fixOnlyIfRewritten=" + this.isFixOnlyIfRewritten() + "]";
    }
}

