/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class Run {
    private static Object mutex = new Object();
    private static Run instance = null;
    private Calendar calendar = Calendar.getInstance();
    private Timer timer = new Timer("PogamutRunDeamon", true);

    public static TimerTaskExt once(long delay, Runnable runnable) {
        return Run.getInstance().runOnce(delay, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Run getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = mutex;
        synchronized (object) {
            if (instance != null) {
                return instance;
            }
            instance = new Run();
        }
        return instance;
    }

    public Date getFutureDate(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(14, (int)millis);
        return calendar.getTime();
    }

    public TimerTaskExt runOnce(long delay, Runnable runnable) {
        TimerTaskExt task = new TimerTaskExt("Once", runnable);
        this.timer.schedule((TimerTask)task, delay);
        return task;
    }

    public static class TimerTaskExt
    extends TimerTask {
        private String name;
        private Runnable runnable;
        private TimerTaskState state = TimerTaskState.SCHEDULED;
        private Throwable exception;

        public TimerTaskExt(String name, Runnable runnable) {
            this.runnable = runnable;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void run() {
            try {
                this.state = TimerTaskState.RUNNING;
                this.runnable.run();
            }
            catch (Exception e) {
                this.exception = e;
                this.state = TimerTaskState.EXCEPTION;
                return;
            }
            this.state = TimerTaskState.SUCCESS;
        }

        public TimerTaskState getState() {
            return this.state;
        }

        public Throwable getException() {
            return this.exception;
        }

        public boolean isState(TimerTaskState state) {
            return this.state == state;
        }

        public boolean isScheduled() {
            return this.state == TimerTaskState.SCHEDULED;
        }

        public boolean isRunning() {
            return this.state == TimerTaskState.RUNNING;
        }

        public boolean isSuccess() {
            return this.state == TimerTaskState.SUCCESS;
        }

        public boolean isException() {
            return this.state == TimerTaskState.EXCEPTION;
        }

        public boolean isCancelled() {
            return this.state == TimerTaskState.CANCELLED;
        }

        @Override
        public boolean cancel() {
            if (super.cancel()) {
                this.state = TimerTaskState.CANCELLED;
                return true;
            }
            return false;
        }
    }

    public static enum TimerTaskState {
        SCHEDULED,
        RUNNING,
        SUCCESS,
        EXCEPTION,
        CANCELLED;

    }
}

