/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IniFile {
    public static final Comparator<SectionEntry> SECTION_ENTRY_INDEX_COMPARATOR = new Comparator<SectionEntry>(){

        @Override
        public int compare(SectionEntry o1, SectionEntry o2) {
            return o1.getSectionEntryIndex() - o2.getSectionEntryIndex();
        }
    };
    public static final Comparator<SectionEntry> SECTION_ENTRY_KEY_COMPARATOR = new Comparator<SectionEntry>(){

        @Override
        public int compare(SectionEntry o1, SectionEntry o2) {
            int val = o1.getKey().compareTo(o2.getKey());
            if (val != 0) {
                return val;
            }
            if (o1 instanceof SectionEntryKeyValue) {
                if (o2 instanceof SectionEntryComment) {
                    return -1;
                }
                return 0;
            }
            if (o1 instanceof SectionEntryComment) {
                if (o2 instanceof SectionEntryKeyValue) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    };
    private Map<String, Section> sections = new TreeMap<String, Section>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toLowerCase().compareTo(o2.toLowerCase());
        }
    });

    public IniFile() {
    }

    public IniFile(File source) {
        if (!source.exists()) {
            throw new PogamutException("File with defaults does not exist at: " + source.getAbsolutePath() + ".", (Object)this);
        }
        this.load(source);
    }

    public IniFile(IniFile ini) {
        for (Section section : ini.getSections()) {
            this.addSection(new Section(section));
        }
    }

    public void load(File source) {
        try {
            this.load(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new PogamutException("Could not load defaults for GameBots2004.ini from file: " + source.getAbsolutePath() + ", caused by: " + e.getMessage(), e);
        }
    }

    public void load(InputStream source) {
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(source));
        Section currSection = null;
        String currComment = null;
        try {
            while (reader.ready()) {
                String line = reader.readLine().trim();
                if (line.length() == 0) continue;
                if (IniFile.isComment(line)) {
                    if (currSection == null) {
                        if (currComment == null) {
                            currComment = line.trim();
                            continue;
                        }
                        currComment = currComment + "\n" + line;
                        continue;
                    }
                    if (IniFile.hasCommentKey(line)) {
                        currSection.addComment(line, currComment);
                        continue;
                    }
                    if (currComment == null) {
                        currComment = line.trim();
                        continue;
                    }
                    currComment = currComment + "\n" + line;
                    continue;
                }
                if (line.startsWith("[") && line.endsWith("]")) {
                    String sectionName;
                    if (currComment != null && currSection != null) {
                        currSection.addComment(currComment);
                    }
                    if (currSection != null && this.getSection(currSection.getName()) == null) {
                        this.addSection(currSection);
                    }
                    if ((currSection = this.getSection(sectionName = line.substring(1, line.length() - 1))) != null) continue;
                    currSection = new Section(sectionName);
                    continue;
                }
                int separ = line.indexOf("=");
                if (separ < 0) continue;
                if (currSection == null) {
                    throw new PogamutException("There is an entry '" + line + "' inside ini file that does not belong to any section.", (Object)this);
                }
                String key = line.substring(0, separ);
                String value = separ + 1 < line.length() ? line.substring(separ + 1, line.length()) : "";
                currSection.put(key, value, currComment);
                currComment = null;
            }
        }
        catch (IOException e) {
            throw new PogamutIOException("Could not completely read file with defaults from stream, caused by: " + e.getMessage(), e, (Object)this);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        if (currSection != null && this.getSection(currSection.getName()) == null) {
            this.addSection(currSection);
        }
    }

    public IniFile addIniFile(IniFile iniFile) {
        for (Section section : iniFile.sections.values()) {
            this.addSection(section);
        }
        return this;
    }

    public Section addSection(String sectionName) {
        return this.addSection(new Section(sectionName));
    }

    public Section addSection(Section section) {
        Section oldSection = this.sections.get(section.getName());
        if (oldSection != null) {
            oldSection.add(section);
            return oldSection;
        }
        this.sections.put(section.getName(), section);
        return section;
    }

    public Section copySection(Section section) {
        Section oldSection = this.sections.get(section.getName());
        if (oldSection != null) {
            oldSection.add(new Section(section));
            return oldSection;
        }
        this.sections.put(section.getName(), section);
        return section;
    }

    public boolean hasSection(String name) {
        return this.sections.containsKey(name);
    }

    public Section getSection(String name) {
        return this.sections.get(name);
    }

    public Set<String> getSectionNames() {
        return this.sections.keySet();
    }

    public Collection<Section> getSections() {
        return this.sections.values();
    }

    public String get(String section, String key) {
        Section sec = this.sections.get(section);
        if (sec == null) {
            return null;
        }
        return sec.get(key);
    }

    public Section set(String section, String key, String value) {
        Section sec = this.sections.get(section);
        if (sec == null) {
            sec = this.addSection(section);
        }
        sec.set(key, value);
        return sec;
    }

    public IniFile set(IniFile values) {
        return this.addIniFile(values);
    }

    public Section set(Section section) {
        return this.addSection(section);
    }

    public static boolean isComment(String line) {
        return line.trim().startsWith(";");
    }

    public static boolean hasKey(String keyValue) {
        if (IniFile.isComment(keyValue)) {
            return false;
        }
        return keyValue.indexOf("=") > 0;
    }

    public static boolean hasCommentKey(String comment) {
        if (!IniFile.isComment(comment)) {
            return false;
        }
        while (comment.startsWith(";")) {
            comment = comment.substring(1);
        }
        int separ = comment.indexOf("=");
        if (separ <= 0) {
            return false;
        }
        String key = comment.substring(0, separ);
        return !key.contains(" ");
    }

    public void backup(String pathToFileToBeCreated) {
        String separator;
        File file = new File(pathToFileToBeCreated);
        String fullpath = file.getAbsolutePath();
        String path = fullpath.lastIndexOf(separator = System.getProperty("file.separator")) >= 0 ? fullpath.substring(0, fullpath.lastIndexOf(separator)) : ".";
        String filename = fullpath.lastIndexOf(separator) >= 0 ? fullpath.substring(fullpath.lastIndexOf(separator) + 1) : "file.ini";
        String name = filename.lastIndexOf(".") >= 0 ? filename.substring(0, filename.lastIndexOf(".")) : filename;
        String extension = filename.lastIndexOf(".") >= 0 ? filename.substring(filename.lastIndexOf(".") + 1) : "ini";
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        name = name + "." + sdf.format(date);
        File targetFile = null;
        int i = 0;
        while ((targetFile = new File(path + separator + name + (i > 0 ? "_" + i : "") + "." + extension)).exists()) {
            ++i;
        }
        this.output(targetFile);
    }

    public void output(String pathToFileToBeCreated) {
        NullCheck.check(pathToFileToBeCreated, "pathToFileToBeCreated");
        this.output(new File(pathToFileToBeCreated));
    }

    public void output(File file) {
        NullCheck.check(file, "file");
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            this.output(writer);
        }
        catch (IOException e) {
            throw new PogamutIOException("Could not write ini file into '" + file.getAbsolutePath() + "', caused by: " + e.getMessage(), e, (Object)this);
        }
        finally {
            writer.close();
        }
    }

    public void output(PrintWriter writer) {
        NullCheck.check(writer, "writer");
        boolean first = true;
        for (Section section : this.sections.values()) {
            if (first) {
                first = false;
            } else {
                writer.println();
            }
            section.output(writer);
        }
    }

    public String output() {
        StringWriter stringWriter = new StringWriter();
        this.output(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static void mergeIntoIniFile(IniFile values, File mergeIntoIniFile) {
        IniFile read = new IniFile(mergeIntoIniFile);
        if (read == null) {
            throw new RuntimeException("Failed to read ini file: " + mergeIntoIniFile.getAbsolutePath());
        }
        read.set(values);
        read.output(mergeIntoIniFile);
    }

    public static class Section {
        private static int nextSectionIndex = 0;
        private int nextSectionEntryIndex = 0;
        private int sectionIndex;
        private String name;
        private List<SectionEntryComment> comments = new ArrayList<SectionEntryComment>();
        private Map<String, SectionEntryKeyValue> props = new HashMap<String, SectionEntryKeyValue>();

        public Section(String name) {
            this.name = name;
            NullCheck.check(this.name, "name");
            this.sectionIndex = nextSectionIndex++;
        }

        public Section(Section section) {
            this.name = section.getName();
            this.sectionIndex = nextSectionIndex++;
            this.add(section);
        }

        public String getName() {
            return this.name;
        }

        public Section put(String key, String value) {
            return this.put(key, value, null);
        }

        public Section put(String key, String value, String comment) {
            NullCheck.check(key, "key");
            SectionEntryKeyValue entry = this.props.get(key);
            if (entry != null) {
                entry.setValue(value);
            } else {
                entry = new SectionEntryKeyValue(this.nextSectionEntryIndex++, key, value, comment);
                this.props.put(key, entry);
            }
            return this;
        }

        public String get(String key) {
            SectionEntryKeyValue entry = this.props.get(key);
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public SectionEntryKeyValue getEntry(String key) {
            SectionEntryKeyValue entry = this.props.get(key);
            if (entry == null) {
                return null;
            }
            return entry;
        }

        public boolean containsKey(String key) {
            return this.props.containsKey(key);
        }

        public Set<String> getKeys() {
            return this.props.keySet();
        }

        public Set<String> keySet() {
            return this.getKeys();
        }

        public SectionEntryKeyValue remove(String key) {
            SectionEntryKeyValue entry = this.props.remove(key);
            this.indexDeleted(entry.getSectionEntryIndex());
            return entry;
        }

        private void indexDeleted(int sectionEntryIndex) {
            for (SectionEntryComment comment : this.comments) {
                if (comment.getSectionEntryIndex() <= sectionEntryIndex) continue;
                comment.setSectionEntryIndex(comment.getSectionEntryIndex() - 1);
            }
            for (SectionEntryKeyValue keyValue : this.props.values()) {
                if (keyValue.getSectionEntryIndex() <= sectionEntryIndex) continue;
                keyValue.setSectionEntryIndex(keyValue.getSectionEntryIndex() - 1);
            }
        }

        public Section clear() {
            this.props.clear();
            this.comments.clear();
            return this;
        }

        public Section clearComments() {
            this.comments.clear();
            return this;
        }

        public Section set(String key, String value) {
            return this.put(key, value);
        }

        public Section set(String key, String value, String comment) {
            return this.put(key, value, comment);
        }

        public void addComment(String comment) {
            if (!comment.startsWith(";")) {
                comment = ";" + comment;
            }
            if (!IniFile.isComment(comment)) {
                throw new RuntimeException("'" + comment + "' is not a comment!");
            }
            this.comments.add(new SectionEntryComment(this.nextSectionEntryIndex++, comment, null));
        }

        public void addComment(String keyValueCommented, String comment) {
            if (!keyValueCommented.startsWith(";")) {
                keyValueCommented = ";" + keyValueCommented;
            }
            if (comment == null) {
                this.addComment(keyValueCommented);
                return;
            }
            if (!comment.startsWith(";")) {
                comment = ";" + comment;
            }
            if (!IniFile.isComment(keyValueCommented)) {
                throw new RuntimeException("'" + keyValueCommented + "' is not a comment!");
            }
            if (!IniFile.hasCommentKey(keyValueCommented)) {
                throw new RuntimeException("'" + keyValueCommented + "' is not commented out key=value!");
            }
            this.comments.add(new SectionEntryComment(this.nextSectionEntryIndex++, keyValueCommented, comment));
        }

        public Section add(Section section) {
            for (SectionEntryKeyValue keyValue : this.props.values()) {
                this.put(keyValue.getKey(), keyValue.getValue());
            }
            for (SectionEntryComment comment : section.comments) {
                this.addComment(comment.getText());
            }
            return this;
        }

        public void output(PrintWriter writer) {
            ArrayList<SectionEntry> output = new ArrayList<SectionEntry>(this.props.values());
            ArrayList<SectionEntryComment> commentsWithKeys = new ArrayList<SectionEntryComment>(this.comments);
            ArrayList<SectionEntryComment> commentsWithoutKeys = new ArrayList<SectionEntryComment>();
            Iterator iter = commentsWithKeys.iterator();
            while (iter.hasNext()) {
                SectionEntryComment comment = (SectionEntryComment)iter.next();
                if (comment.getKey() == null || comment.getKey().length() <= 0) {
                    commentsWithoutKeys.add(comment);
                    iter.remove();
                    continue;
                }
                output.add(comment);
            }
            Collections.sort(output, SECTION_ENTRY_KEY_COMPARATOR);
            this.mergeInComments(output, commentsWithoutKeys);
            writer.print("[");
            writer.print(this.name);
            writer.println("]");
            for (SectionEntry entry : output) {
                writer.println(entry.getIniFileLine());
            }
        }

        private void mergeInComments(List<SectionEntry> output, List<SectionEntryComment> commentsWithKeys) {
            if (output.size() == 0) {
                output.addAll(commentsWithKeys);
                Collections.sort(output, SECTION_ENTRY_INDEX_COMPARATOR);
                return;
            }
            while (commentsWithKeys.size() > 0) {
                Iterator<SectionEntryComment> iter = commentsWithKeys.iterator();
                while (iter.hasNext()) {
                    SectionEntryComment comment = iter.next();
                    if (!this.mergeInComment(output, comment)) continue;
                    iter.remove();
                }
            }
        }

        private boolean mergeInComment(List<SectionEntry> output, SectionEntryComment comment) {
            if (output.size() == 0) {
                output.add(comment);
                return true;
            }
            for (int i = 0; i < output.size(); ++i) {
                SectionEntry entry = output.get(i);
                if (entry.getSectionEntryIndex() - 1 != comment.getSectionEntryIndex()) continue;
                output.add(i, comment);
                return true;
            }
            if (comment.getSectionEntryIndex() - 1 == output.get(output.size() - 1).getSectionEntryIndex()) {
                output.add(comment);
                return true;
            }
            return false;
        }

        public String toString() {
            return "IniFile.Section[name=" + this.name + ", entries=" + this.props.size() + "]";
        }
    }

    public static class SectionEntryKeyValue
    extends SectionEntry {
        private String comment;
        private String key;
        private String value;

        public SectionEntryKeyValue(int sectionEntryIndex, String key, String value, String comment) {
            super(sectionEntryIndex);
            this.key = key;
            this.value = value;
            this.comment = comment;
            if (this.comment != null && !this.comment.startsWith(";")) {
                this.comment = ";" + this.comment;
            }
            NullCheck.check(this.key, "key");
            NullCheck.check(this.value, "value");
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public String getIniFileLine() {
            if (this.comment != null) {
                return this.comment + "\n" + this.key + "=" + this.value;
            }
            return this.key + "=" + this.value;
        }
    }

    public static class SectionEntryComment
    extends SectionEntry {
        private String comment;
        private String text;
        private String key = null;

        public SectionEntryComment(int sectionEntryIndex, String text, String comment) {
            super(sectionEntryIndex);
            NullCheck.check(text, "text");
            if (!text.startsWith(";")) {
                text = ";" + text;
            }
            this.text = text;
            int separ = text.indexOf("=");
            if (separ < 0) {
                return;
            }
            this.key = text.substring(0, separ);
            if (this.key == null || this.key.isEmpty()) {
                return;
            }
            while (this.key.startsWith(";")) {
                this.key = this.key.substring(1);
            }
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @Override
        public String getIniFileLine() {
            if (this.comment != null) {
                return this.comment + "\n" + this.text;
            }
            return this.text;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static abstract class SectionEntry {
        private int sectionEntryIndex;

        public SectionEntry(int sectionEntryIndex) {
            this.sectionEntryIndex = sectionEntryIndex;
        }

        public int getSectionEntryIndex() {
            return this.sectionEntryIndex;
        }

        protected void setSectionEntryIndex(int sectionEntryIndex) {
            this.sectionEntryIndex = sectionEntryIndex;
        }

        public abstract String getIniFileLine();

        public abstract String getKey();
    }
}

