package cz.cuni.amis.utils.floydwarshall;

import cz.cuni.amis.utils.astar.AStarGoal;

/**
 * This interface provides additional information about the map Floyd-Warshall algorithm is going to work with.
 * <p><p>
 * Generally, you will use {@link FWMap} interface to define the map in general and then use this {@link FWMapView} interface
 * to specify a specific needs you need to impose over the map as is "forbidding" some nodes or "imposing additional costs 
 * onto the nodes".
 *   
 * @author Jimmy
 */
@Deprecated
public interface FWMapView<NODE> {
	
	/**
	 * Method defining extra-node cost, that is a cost that is attached to the "node", by having such node on the path costs 
	 * This allows you to provide "customization" to the graph nodes, basicly it is a way of telling "this node is cool to have in path" (negative cost)
	 * or "this node is bad to have in path" (positive cost).
	 * 
	 * @param nodeFrom
	 * @param nodeTo
	 * 
	 * @return
	 */
	public int getNodeExtraCost(NODE node);
	
	/**
	 * Method defining extra-edge cost, similar to {@link AStarGoal#getExtraCost(Object, Object)}. This allows you to
	 * provide "customization" to the graph edge lengths. It allows you to say "this is a cool edge to use for travel" (negative extra cost)
	 * or "this edge is hard to cross" (positive extra cost).
	 * 
	 * @param nodeFrom
	 * @param nodeTo
	 * 
	 * @return
	 */
	public int getEdgeExtraCost(NODE nodeFrom, NODE nodeTo);

	/**
	 * Method defining which nodes are allowed to be explored / used by {@link FloydWarshall} for the purpose of path planning.
	 * May be used to define "forbidden" nodes, i.e., FloydWarshal will never return path leading to such nodes or using such nodes, it would
	 * act as edges into / from this node are non-existing.
	 * 
	 * @param node
	 * 
	 * @return
	 */
	public boolean isNodeOpened(NODE node);
	
	/**
	 * Method defining which "edges" (oriented links between nodes) can be used for the purpose of path-planning. It can be used
	 * to "forbid" usage of some edges, that is you can rule out some edges you do not want your agent to be able to travel.
	 * 
	 * @param nodeFrom
	 * @param nodeTo
	 * 
	 * @return
	 */
	public boolean isEdgeOpened(NODE nodeFrom, NODE nodeTo);

}
