/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite.rewriter;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.utils.rewrite.rewriter.ISubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@XStreamAlias(value="substitution")
public class Substitution
implements ISubstitution {
    @XStreamAlias(value="match")
    private String reMatchOrig;
    private String reMatch;
    @XStreamAlias(value="replace")
    private String reSubstOrig;
    private String reSubst;
    @XStreamAlias(value="multiLine")
    private Boolean multiLine;
    @XStreamAlias(value="caseSensitive")
    private Boolean caseSensitive;
    @XStreamAlias(value="replaceVariables")
    private Boolean replaceVariables;
    @XStreamOmitField
    private transient Pattern pattern;
    public static final Pattern SIMPLE_PARAM = Pattern.compile("\\$([a-zA-Z0-9_]+)");
    public static final Pattern FORMAL_PARAM = Pattern.compile("\\$\\{(.+)\\}");

    public Substitution() {
    }

    public Substitution(String reMatch, String reSubst, boolean caseSensitive, boolean multiLine, boolean replaceVariables) {
        this.reMatchOrig = this.reMatch = reMatch;
        this.reSubstOrig = this.reSubst = reSubst;
        this.caseSensitive = caseSensitive;
        this.multiLine = multiLine;
        this.replaceVariables = replaceVariables;
        if (this.replaceVariables.booleanValue()) {
            this.replaceVariables();
        }
    }

    private Substitution readResolve() {
        if (this.caseSensitive == null) {
            this.caseSensitive = true;
        }
        if (this.multiLine == null) {
            this.multiLine = false;
        }
        if (this.replaceVariables == null) {
            this.replaceVariables = true;
        }
        this.reSubst = this.reSubstOrig;
        if (this.replaceVariables.booleanValue()) {
            this.replaceVariables();
        }
        return this;
    }

    public static String substituteParams(String string) {
        ArrayList<Tuple3<Integer, Integer, String>> params = new ArrayList<Tuple3<Integer, Integer, String>>();
        int i = 0;
        while (i < 2) {
            Matcher m = i == 0 ? SIMPLE_PARAM.matcher(string) : FORMAL_PARAM.matcher(string);
            while (m.find()) {
                params.add(new Tuple3<Integer, Integer, String>(m.start(), m.group().length(), m.group(1)));
            }
            ++i;
        }
        if (params.size() == 0) {
            return string;
        }
        Collections.sort(params, new Comparator<Tuple3<Integer, Integer, String>>(){

            @Override
            public int compare(Tuple3<Integer, Integer, String> o1, Tuple3<Integer, Integer, String> o2) {
                return o2.getFirst() - o1.getFirst();
            }
        });
        String result = string;
        for (Tuple3 tuple3 : params) {
            String paramValue = System.getenv((String)tuple3.getThird());
            if (paramValue == null) {
                paramValue = System.getProperty((String)tuple3.getThird());
            }
            if (paramValue == null) {
                throw new RuntimeException("Parameter '" + (String)tuple3.getThird() + "' not found! Both System.getenv(\"" + (String)tuple3.getThird() + "\") and System.getProperty(\"" + (String)tuple3.getThird() + "\") evaluates to null!");
            }
            result = String.valueOf(result.substring(0, (Integer)tuple3.getFirst())) + paramValue + result.substring((Integer)tuple3.getFirst() + (Integer)tuple3.getSecond());
        }
        return result;
    }

    private void replaceVariables() {
        this.reMatch = Substitution.substituteParams(this.reMatchOrig);
        this.reSubst = Substitution.substituteParams(this.reSubstOrig);
    }

    public String getReMatch() {
        return this.reMatch;
    }

    public void setReMatch(String reMatch) {
        this.reMatch = reMatch;
        this.pattern = null;
    }

    public String getReSubstOrig() {
        return this.reSubstOrig;
    }

    public void setReSubstOrig(String reSubstOrig) {
        this.reSubstOrig = reSubstOrig;
    }

    public String getReSubst() {
        return this.reSubst;
    }

    public void setReSubst(String reSubst) {
        this.reSubst = reSubst;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.reMatch, (this.caseSensitive != false ? 0 : 2) | (this.multiLine != false ? 0 : 8));
        }
        return this.pattern;
    }

    public Matcher getMatcher(String str) {
        return this.getPattern().matcher(str);
    }

    @Override
    public String substitute(String str) {
        return this.getMatcher(str).replaceAll(this.reSubst);
    }

    @Override
    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public String toString() {
        return "Substitution[" + (this.caseSensitive != false ? "case-sensitive" : "case-INsensitive") + ", " + (this.multiLine != false ? "multi-line pattern" : "single-line pattern") + " | " + this.reMatch + " --> " + this.reSubst + "]";
    }

    private static class Tuple3<FIRST, SECOND, THIRD> {
        private FIRST first;
        private SECOND second;
        private THIRD third;

        public Tuple3(FIRST first, SECOND second, THIRD third) {
            this.first = first;
            this.second = second;
            this.third = third;
        }

        public FIRST getFirst() {
            return this.first;
        }

        public void setFirst(FIRST first) {
            this.first = first;
        }

        public SECOND getSecond() {
            return this.second;
        }

        public void setSecond(SECOND second) {
            this.second = second;
        }

        public THIRD getThird() {
            return this.third;
        }

        public void setThird(THIRD third) {
            this.third = third;
        }
    }
}

