/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.rewrite;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import cz.cuni.amis.utils.rewrite.IncludeDir;
import cz.cuni.amis.utils.rewrite.rewriter.Const;
import cz.cuni.amis.utils.rewrite.rewriter.FixLineEndings;
import cz.cuni.amis.utils.rewrite.rewriter.Substitution;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="includeDir")
public class IncludeDirForSubstitutions
extends IncludeDir {
    @XStreamAlias(value="substitutions")
    private List<Substitution> substitutions = new ArrayList<Substitution>();
    @XStreamAlias(value="fixLineEndings")
    private FixLineEndings lineEndings = null;

    public IncludeDirForSubstitutions() {
    }

    public IncludeDirForSubstitutions(IncludeDir source) {
        super(source);
    }

    public IncludeDirForSubstitutions(IncludeDirForSubstitutions orig, IncludeDirForSubstitutions globals) {
        super(orig, globals);
        if (orig.substitutions != null) {
            for (Substitution subst : orig.substitutions) {
                this.substitutions.add(subst);
            }
        }
        if (globals.substitutions != null) {
            for (Substitution subst : globals.substitutions) {
                this.substitutions.add(subst);
            }
        }
    }

    private IncludeDirForSubstitutions readResolve() {
        if (this.getSubdirs() == null) {
            this.setSubdirs(true);
        }
        if (this.getExcludeDirs() == null) {
            this.setExcludeDirs(new ArrayList<String>(0));
        }
        if (this.getIncludeFiles() == null) {
            this.setIncludeFiles(new ArrayList<String>(0));
        }
        if (this.getExcludeFiles() == null) {
            this.setExcludeFiles(new ArrayList<String>(0));
        }
        return this;
    }

    public FixLineEndings getLineEndings() {
        return this.lineEndings;
    }

    public void setLineEndings(FixLineEndings lineEndings) {
        this.lineEndings = lineEndings;
    }

    public List<Substitution> getSubstitutions() {
        return this.substitutions;
    }

    public void setSubstitutions(List<Substitution> substitutions) {
        this.substitutions = substitutions;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.substitutions == null) {
            this.substitutions = new ArrayList<Substitution>(0);
        }
    }

    @Override
    public String toString() {
        return this.toString("IncludeDir", "");
    }

    @Override
    public String toString(String name, String prefix) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        sb.append(String.valueOf(prefix) + name + "[");
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  dir           = " + this.getDir() + (this.getDir() != null ? " --> " + this.getDir().getAbsolutePath() : ""));
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  subdirs       = " + this.getSubdirs());
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  includeFiles  = ");
        if (this.getIncludeFiles() == null) {
            sb.append("null");
        } else {
            for (String file : this.getIncludeFiles()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeFiles  = ");
        if (this.getExcludeFiles() == null) {
            sb.append("null");
        } else {
            for (String file : this.getExcludeFiles()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  excludeDirs   = ");
        if (this.getExcludeDirs() == null) {
            sb.append("null");
        } else {
            for (String file : this.getExcludeDirs()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(file);
            }
        }
        first = true;
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  substitutions = ");
        if (this.substitutions == null) {
            sb.append("null");
        } else {
            for (Substitution subst : this.substitutions) {
                sb.append(Const.NEW_LINE);
                sb.append(prefix);
                sb.append("    ");
                sb.append(subst);
            }
        }
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "  fixLineEndings = " + String.valueOf(this.lineEndings));
        sb.append(String.valueOf(Const.NEW_LINE) + prefix + "]");
        return sb.toString();
    }
}

