package cz.cuni.amis.utils.rewrite.rewriter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;

@XStreamAlias(value = "substitution")
public class Substitution {
	
	@XStreamAlias(value = "match")
	private String reMatch;
	
	@XStreamAlias(value = "replace")
	private String reSubst;
	
	@XStreamAlias(value = "multiLine")
	private Boolean multiLine;
	
	@XStreamAlias(value = "caseSensitive")
	private Boolean caseSensitive;

	@XStreamOmitField
	private transient Pattern pattern;
	
	public Substitution() {		
	}
	
	public Substitution(String reMatch, String reSubst, boolean caseSensitive, boolean multiLine) {
		this.reMatch = reMatch;
		this.reSubst = reSubst;
		this.caseSensitive = caseSensitive;
		this.multiLine = multiLine;
	}
	
	private Substitution readResolve() {
		if (caseSensitive == null) caseSensitive = true;
		if (multiLine == null) multiLine = false;
		return this;
	}

	public String getReMatch() {
		return reMatch;
	}

	public void setReMatch(String reMatch) {		
		this.reMatch = reMatch;
		this.pattern = null;
	}

	public String getReSubst() {
		return reSubst;
	}

	public void setReSubst(String reSubst) {
		this.reSubst = reSubst;
	}
	
	public Pattern getPattern() {
		if (pattern == null) {
			pattern = Pattern.compile(reMatch, (caseSensitive ? 0 : Pattern.CASE_INSENSITIVE) | (multiLine ? 0 : Pattern.MULTILINE));
		}
		return pattern;
	}
	
	public Matcher getMatcher(String str) {
		return getPattern().matcher(str);
	}
	
	public String substitute(String str) {
		return getMatcher(str).replaceAll(reSubst);
	}
	
	public boolean isMultiLine() {
		return multiLine;
	}

	public void setMultiLine(boolean multiLine) {
		this.multiLine = multiLine;
	}

	public boolean isCaseSensitive() {
		return caseSensitive;
	}

	public void setCaseSensitive(boolean caseSensitive) {
		this.caseSensitive = caseSensitive;
	}

	/**
	 * Warning! Once you set the patter manually, IT WON'T BE CONSTRUCTED AUTOMATICALLY FROM SUBSTITUTION SETTINGS! 
	 * See {@link Substitution#setPattern(Pattern)}.
	 * 
	 * @param pattern
	 */
	public void setPattern(Pattern pattern) {
		this.pattern = pattern;
	}

	@Override
	public String toString() {
		return "Substitution[" + (caseSensitive ? "case-sensitive" : "case-INsensitive") + ", " + (multiLine ? "multi-line pattern" : "single-line pattern") + " | " + reMatch + " --> " + reSubst + "]";
	}

}
