/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.udk.agent.module.sensomotoric;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.udk.bot.impl.UDKBot;
import cz.cuni.amis.pogamut.udk.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.udk.communication.messages.gbinfomessages.ConfigChange;
import java.util.logging.Logger;

public class AgentConfig
extends SensorModule<UDKBot> {
    private ConfigChangeListener configChangeListener;
    private ConfigChange lastConfig = null;
    private UDKBot bot;

    public boolean isManualSpawn() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isManualSpawn();
    }

    public void setManualSpawn(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setManualSpawn(state));
    }

    public boolean isAutoTrace() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isAutoTrace();
    }

    public void setAutoTrace(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setAutoTrace(state));
    }

    public String getName() {
        if (this.lastConfig == null) {
            return "unknown yet";
        }
        return this.lastConfig.getName();
    }

    public void setName(String newName) {
        this.bot.getAct().act((CommandMessage)new Configuration().setName(newName));
        this.bot.getComponentId().getName().setFlag((Object)newName);
    }

    public double getSpeedMultiplier() {
        if (this.lastConfig == null) {
            return -1.0;
        }
        return this.lastConfig.getSpeedMultiplier();
    }

    public void setSpeedMultiplier(double value) {
        if (value < 0.1) {
            value = 0.1;
        } else if (value > 2.0) {
            value = 2.0;
        }
        this.bot.getAct().act((CommandMessage)new Configuration().setSpeedMultiplier(value));
    }

    public boolean isInvulnerable() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isInvulnerable();
    }

    public void setInvulnerability(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setInvulnerable(state));
    }

    public double getVisionTime() {
        if (this.lastConfig == null) {
            return -1.0;
        }
        return this.lastConfig.getVisionTime();
    }

    public void setVisionTime(double value) {
        if (value < 0.1) {
            value = 0.1;
        } else if (value > 2.0) {
            value = 2.0;
        }
        this.bot.getAct().act((CommandMessage)new Configuration().setVisionTime(value));
    }

    public boolean isShowDebug() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isShowDebug();
    }

    public void setShowDebug(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setShowDebug(state));
    }

    public boolean isShowFocalPoint() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isShowFocalPoint();
    }

    public void setShowFocalPoint(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setShowFocalPoint(state));
    }

    public boolean isDrawTraceLines() {
        if (this.lastConfig == null) {
            return false;
        }
        return this.lastConfig.isDrawTraceLines();
    }

    public void setDrawTraceLines(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setDrawTraceLines(state));
    }

    public boolean isSynchronousBatchExported() {
        if (this.lastConfig == null) {
            return false;
        }
        return !this.lastConfig.isSynchronousOff();
    }

    public void setSynchronousBatchExport(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setSynchronousOff(!state));
    }

    public boolean isAutoPickup() {
        if (this.lastConfig == null) {
            return false;
        }
        return !this.lastConfig.isAutoPickupOff();
    }

    public void setAutoPickup(boolean state) {
        this.bot.getAct().act((CommandMessage)new Configuration().setAutoPickupOff(!state));
    }

    public Rotation getRotationSpeed() {
        if (this.lastConfig == null) {
            return null;
        }
        return this.lastConfig.getRotationRate();
    }

    public void setRotationHorizontalSpeed(double speed) {
        Rotation actual = this.getRotationSpeed();
        if (actual == null) {
            return;
        }
        actual = new Rotation(actual).setYaw(speed);
        this.bot.getAct().act((CommandMessage)new Configuration().setRotationRate(actual));
    }

    public void setRotationVerticalSpeed(double speed) {
        Rotation actual = this.getRotationSpeed();
        if (actual == null) {
            return;
        }
        actual = new Rotation(actual).setPitch(speed);
        this.bot.getAct().act((CommandMessage)new Configuration().setRotationRate(actual));
    }

    public void setRotationSpeed(Rotation rotationSpeeds) {
        this.bot.getAct().act((CommandMessage)new Configuration().setRotationRate(rotationSpeeds));
    }

    public ConfigChange getConfig() {
        return this.lastConfig;
    }

    protected void start(boolean startPaused) {
        super.start(startPaused);
        this.lastConfig = null;
    }

    public AgentConfig(UDKBot bot) {
        this(bot, null);
    }

    public AgentConfig(UDKBot bot, LogCategory moduleLog) {
        super((IObservingAgent)bot, (Logger)moduleLog);
        this.bot = bot;
        this.configChangeListener = new ConfigChangeListener((IWorldView)bot.getWorldView());
    }

    private class ConfigChangeListener
    implements IWorldObjectEventListener<ConfigChange, IWorldObjectEvent<ConfigChange>> {
        private IWorldView worldView;

        public ConfigChangeListener(IWorldView worldView) {
            worldView.addObjectListener(ConfigChange.class, WorldObjectFirstEncounteredEvent.class, (IWorldObjectEventListener)this);
            this.worldView = worldView;
        }

        public void notify(IWorldObjectEvent<ConfigChange> event) {
            AgentConfig.this.lastConfig = (ConfigChange)event.getObject();
        }
    }
}

