/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.nb.pogamut.base.logging;

import cz.cuni.amis.nb.pogamut.base.logging.LogNode;
import cz.cuni.amis.nb.pogamut.base.logging.LogRecordsSource;
import cz.cuni.amis.nb.pogamut.base.logging.LogTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class LogViewerPane
extends JPanel
implements Serializable {
    private JButton jButton1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JTable jTable1;
    private JToggleButton jToggleButton1;
    private JTextArea logDetail;

    public LogViewerPane() {
        this.initComponents();
        TableColumnModel model = this.jTable1.getColumnModel();
        for (int i = 0; i < 2; ++i) {
            model.getColumn(i).setPreferredWidth(120);
            model.getColumn(i).setMaxWidth(120);
        }
        model.getColumn(2).setPreferredWidth(400);
        model.getColumn(2).setMaxWidth(4000);
        LogLevelColorRenderer cellRenderer = new LogLevelColorRenderer();
        model.getColumn(0).setCellRenderer(cellRenderer);
        model.getColumn(1).setCellRenderer(cellRenderer);
        model.getColumn(2).setCellRenderer(cellRenderer);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (LogViewerPane.this.jTable1.getSelectedRow() >= 0) {
                    String str = LogViewerPane.this.jTable1.getModel().getValueAt(LogViewerPane.this.jTable1.getSelectedRow(), 2).toString();
                    LogViewerPane.this.logDetail.setText(str);
                }
            }
        });
    }

    public LogTableModel getLogTableModel() {
        return (LogTableModel)this.jTable1.getModel();
    }

    public void setLogNode(LogNode node) {
        this.getLogTableModel().removeAllDataSources();
        this.getLogTableModel().addDataSource(node.getLogRecordsSource());
        this.jToggleButton1.setSelected(this.getLogTableModel().isFreezed());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.logDetail = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jToggleButton1 = new JToggleButton();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                if (rowIndex < this.getModel().getRowCount()) {
                    Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(this.getValueAt(rowIndex, vColIndex).toString());
                    }
                    return c;
                }
                return null;
            }
        };
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Log record detail"));
        this.jPanel1.setPreferredSize(new Dimension(84, 100));
        this.jPanel1.setLayout(new BorderLayout());
        this.logDetail.setColumns(20);
        this.logDetail.setEditable(false);
        this.logDetail.setLineWrap(true);
        this.logDetail.setRows(5);
        this.jScrollPane3.setViewportView(this.logDetail);
        this.jPanel1.add((Component)this.jScrollPane3, "Center");
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jToggleButton1.setText("Freeze");
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewerPane.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jToggleButton1);
        this.jButton1.setText("Clear all");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewerPane.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel3.add((Component)this.jPanel1, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.jTable1.setModel(new LogTableModel());
        this.jTable1.setAutoResizeMode(1);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        ((LogTableModel)this.jTable1.getModel()).setFreeze(this.jToggleButton1.isSelected());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        for (LogRecordsSource lrs : ((LogTableModel)this.jTable1.getModel()).getDataSources()) {
            lrs.clear();
        }
    }

    public class LogLevelColorRenderer
    extends DefaultTableCellRenderer {
        private Map<Level, Color> levelColors = new HashMap<Level, Color>();

        public LogLevelColorRenderer() {
            this.levelColors.put(Level.INFO, new Color(0, 159, 0));
            this.levelColors.put(Level.SEVERE, Color.RED);
            this.levelColors.put(Level.WARNING, Color.MAGENTA);
            this.levelColors.put(Level.CONFIG, Color.BLUE);
            this.levelColors.put(Level.FINE, Color.DARK_GRAY);
            this.levelColors.put(Level.FINER, Color.LIGHT_GRAY);
            this.levelColors.put(Level.FINEST, Color.LIGHT_GRAY);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object level, boolean isSelected, boolean hasFocus, int row, int column) {
            LogTableModel.LogLevelObject obj = (LogTableModel.LogLevelObject)level;
            if (this.levelColors.containsKey(obj.level)) {
                this.setForeground(this.levelColors.get(obj.level));
            } else {
                this.setForeground(Color.BLACK);
            }
            this.setFont(Font.getFont("SansSerif"));
            return super.getTableCellRendererComponent(table, obj.msg, isSelected, hasFocus, row, column);
        }
    }
}

