/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.pddl;

import cz.cuni.amis.planning4j.pddl.AbstractPDDLAction;
import cz.cuni.amis.planning4j.pddl.PDDLOperators;
import cz.cuni.amis.planning4j.pddl.PDDLParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PDDLGroundAction
extends AbstractPDDLAction {
    private List<String> preconditionList;
    private List<String> positiveEffects;
    private List<String> negativeEffects;

    public PDDLGroundAction(String name, PDDLParameter ... parameters) {
        super(name, parameters);
        this.init();
    }

    public PDDLGroundAction(String name, List<PDDLParameter> parameters) {
        super(name, parameters);
        this.init();
    }

    public PDDLGroundAction(String name) {
        super(name);
        this.init();
    }

    private void init() {
        this.preconditionList = Collections.EMPTY_LIST;
        this.positiveEffects = Collections.EMPTY_LIST;
        this.negativeEffects = Collections.EMPTY_LIST;
    }

    public List<String> getNegativeEffects() {
        return this.negativeEffects;
    }

    public void setNegativeEffects(List<String> negativeEffects) {
        this.negativeEffects = negativeEffects;
    }

    public void setNegativeEffects(String ... negativeEffects) {
        this.setNegativeEffects(Arrays.asList(negativeEffects));
    }

    public List<String> getPositiveEffects() {
        return this.positiveEffects;
    }

    public void setPositiveEffects(List<String> positiveEffects) {
        this.positiveEffects = positiveEffects;
    }

    public void setPositiveEffects(String ... positiveEffects) {
        this.setPositiveEffects(Arrays.asList(positiveEffects));
    }

    public List<String> getPreconditionList() {
        return this.preconditionList;
    }

    public void setPreconditionList(List<String> preconditionList) {
        this.preconditionList = preconditionList;
    }

    public void setPreconditionList(String ... preconditionList) {
        this.setPreconditionList(Arrays.asList(preconditionList));
    }

    public String getPreconditionAsString() {
        if (this.preconditionList == null || this.preconditionList.isEmpty()) {
            return null;
        }
        return PDDLOperators.makeAnd(this.preconditionList);
    }

    public String getEffectAsString() {
        if (this.negativeEffects.isEmpty()) {
            if (this.positiveEffects.isEmpty()) {
                return "";
            }
            return PDDLOperators.makeAnd(this.positiveEffects);
        }
        String negativeEffExpression = PDDLOperators.makeNot(PDDLOperators.makeAnd(this.negativeEffects));
        if (this.positiveEffects.isEmpty()) {
            return negativeEffExpression;
        }
        ArrayList<String> allEffects = new ArrayList<String>(this.positiveEffects);
        allEffects.add(negativeEffExpression);
        return PDDLOperators.makeAnd(allEffects);
    }
}

