/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.planning4j.impl;

import cz.cuni.amis.planning4j.impl.AbstractWriterBasedProblemProvider;
import cz.cuni.amis.planning4j.pddl.PDDLProblem;
import java.io.IOException;
import java.io.Writer;

public class PDDLProblemProvider
extends AbstractWriterBasedProblemProvider {
    private PDDLProblem problem;

    public PDDLProblemProvider(PDDLProblem problem) {
        this.problem = problem;
    }

    @Override
    public PDDLProblem getProblemAsPDDL() {
        return this.problem;
    }

    @Override
    public void writeProblem(Writer writer) throws IOException {
        writer.write("(define (problem " + this.problem.getProblemName() + ") (:domain " + this.problem.getDomainName() + ")\n");
        if (!this.problem.getInitialLiterals().isEmpty()) {
            writer.write("\t(:init \n");
            for (String literal : this.problem.getInitialLiterals()) {
                writer.write("\t\t(" + literal + ")\n");
            }
            writer.write("\t)\n");
        }
        writer.write("\t(:goal (" + this.problem.getGoalConditionAsString() + "))\n");
        writer.write(")\n");
    }
}

