/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.heap;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.heap.Heap;
import java.util.ArrayList;
import java.util.Comparator;
import org.junit.Test;

public class Test01_Heap
extends BaseTest {
    public String mainToStr(Integer[] nums) {
        if (nums.length == 0) {
            return "";
        }
        String str = nums[0].toString();
        for (int i = 1; i < nums.length; ++i) {
            str = str + ", " + nums[i].toString();
        }
        return str;
    }

    public boolean mainCheck(Heap heap, Integer[] nums) {
        log.info("Removing and checking " + this.mainToStr(nums));
        ArrayList<Object> heapInts = new ArrayList<Object>();
        ArrayList<Integer> desiredInts = new ArrayList<Integer>();
        for (int i = 0; i < nums.length; ++i) {
            desiredInts.add(nums[i]);
            heapInts.add(heap.getMin());
            heap.deleteMin();
        }
        if (heapInts.containsAll(desiredInts)) {
            log.info("OK");
            return true;
        }
        this.testFailed("KO!");
        return false;
    }

    public void mainAdd(Heap heap, Integer[] nums) {
        log.info("Adding: " + this.mainToStr(nums));
        for (int i = 0; i < nums.length; ++i) {
            heap.add((Object)nums[i]);
        }
    }

    @Test
    public void test() {
        Heap heap = new Heap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return (Integer)arg0 - (Integer)arg1;
            }
        }, 20);
        this.mainAdd(heap, new Integer[]{10, 100, 1, 50, 5});
        this.mainCheck(heap, new Integer[]{1, 5});
        this.mainCheck(heap, new Integer[]{10, 50});
        this.mainAdd(heap, new Integer[]{80, 60, 70});
        this.mainCheck(heap, new Integer[]{60, 70, 80, 100});
        this.mainAdd(heap, new Integer[]{5, 8, 3, 7, 4, 1, 9});
        this.mainCheck(heap, new Integer[]{5, 8, 3, 7, 4, 1, 9});
        this.mainAdd(heap, new Integer[]{2, 7, 3, 5, 6, 4, 9, 1});
        this.mainCheck(heap, new Integer[]{1, 2, 3, 4});
        this.mainAdd(heap, new Integer[]{20, 70, 30, 50, 60, 2, 3, 1, 4});
        this.mainCheck(heap, new Integer[]{20, 70, 30, 50, 60, 2, 3, 1, 4, 5, 6, 7, 9});
        this.testOk();
    }
}

