/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListenerMock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.junit.Test;

public class Test03_Serialization {
    @Test
    public void test03() {
        System.out.println("Testing de/serialization of the Flag...");
        Flag flag1 = new Flag((Object)true);
        Flag flag2 = new Flag((Object)false);
        try {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(bytesOut);
            output.writeObject(flag1);
            output.writeObject(flag2);
            byte[] byteArray = bytesOut.toByteArray();
            ByteArrayInputStream bytesIn = new ByteArrayInputStream(byteArray);
            ObjectInputStream input = new ObjectInputStream(bytesIn);
            Flag flag1_read = (Flag)input.readObject();
            Flag flag2_read = (Flag)input.readObject();
            Assert.assertTrue((String)"flag1_read should have value 'true'", (boolean)((Boolean)flag1_read.getFlag()).equals(true));
            Assert.assertTrue((String)"flag2_read should have value 'true'", (boolean)((Boolean)flag2_read.getFlag()).equals(false));
            System.out.println("Flags read OK");
            FlagListenerMock<Boolean> fl1 = new FlagListenerMock<Boolean>();
            FlagListenerMock<Boolean> fl2 = new FlagListenerMock<Boolean>();
            FlagListenerMock<Boolean> fl3 = new FlagListenerMock<Boolean>();
            flag1_read.addListener(fl1);
            flag1_read.setFlag((Object)false);
            flag1_read.setFlag((Object)false);
            flag1_read.addListener(fl2);
            flag1_read.setFlag((Object)true);
            flag1_read.setFlag((Object)true);
            flag1_read.addListener(fl3);
            flag1_read.setFlag((Object)false);
            flag1_read.setFlag((Object)false);
            fl1.checkValuesInOrder("FlagListener1", new Boolean[]{false, true, false});
            fl2.checkValuesInOrder("FlagListener2", new Boolean[]{true, false});
            fl3.checkValuesInOrder("FlagListener3", new Boolean[]{false});
            flag1_read.removeListener(fl1);
            flag1_read.setFlag((Object)true);
            flag1_read.setFlag((Object)true);
            flag1_read.removeListener(fl2);
            flag1_read.setFlag((Object)false);
            flag1_read.setFlag((Object)false);
            flag1_read.removeListener(fl3);
            flag1_read.setFlag((Object)true);
            flag1_read.setFlag((Object)true);
            fl1.checkValuesInOrder("FlagListener1", new Boolean[0]);
            fl2.checkValuesInOrder("FlagListener2", new Boolean[]{true});
            fl3.checkValuesInOrder("FlagListener3", new Boolean[]{true, false});
            System.out.println("Flag1_read still functional - listeners fire as expected.");
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"IOException!", (boolean)false);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            Assert.assertTrue((String)"Class not found exception!", (boolean)false);
        }
        System.out.println("---/// TEST OK ///---");
    }
}

