/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.astar;

import cz.cuni.amis.utils.astar.AStarHeap;
import cz.cuni.amis.utils.astar.AStarHeapComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.junit.Before;
import org.junit.Test;

public class Test02_AStarHeap {
    Map<Integer, Integer> costs;
    AStarHeapComparator<Integer> comparator;
    AStarHeap<Integer> heap;

    @Before
    public void setup() {
        this.costs = new HashMap<Integer, Integer>();
        this.comparator = new AStarHeapComparator(this.costs);
        this.heap = new AStarHeap(this.comparator);
    }

    private void initCosts(int num) {
        for (int i = 0; i < num; ++i) {
            this.costs.put(i, i);
        }
    }

    private void initRevertCosts(int num) {
        for (int i = 0; i < num; ++i) {
            this.costs.put(i, num - i);
        }
    }

    private void putInHeap(int num) {
        for (int i = 0; i < num; ++i) {
            this.heap.add((Object)i);
        }
    }

    private void putInHeapRandom(int num) {
        ArrayList<Integer> array = new ArrayList<Integer>(num);
        for (int i = 0; i < num; ++i) {
            array.add(i);
        }
        Random random = new Random(System.currentTimeMillis());
        while (array.size() > 0) {
            this.heap.add(array.remove(random.nextInt(array.size())));
        }
    }

    @Test
    public void test1_Put100Sequention() {
        System.out.println("test1_Put100Sequention()");
        this.initCosts(100);
        this.putInHeap(100);
        for (int i = 0; i < 100; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test2_Put100Random() {
        System.out.println("test2_Put100Random()");
        this.initCosts(100);
        this.putInHeapRandom(100);
        for (int i = 0; i < 100; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test3_Put10000Random() {
        System.out.println("test3_Put10000Random()");
        this.initCosts(10000);
        this.putInHeapRandom(10000);
        for (int i = 0; i < 10000; ++i) {
            if ((Integer)this.heap.getMin() != i) {
                System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test4_100x_Put10000Random() {
        System.out.println("test4_100x_Put10000Random()");
        this.initCosts(10000);
        for (int j = 0; j < 100; ++j) {
            System.out.println("Test " + (j + 1) + " / 100");
            this.putInHeapRandom(10000);
            for (int i = 0; i < 10000; ++i) {
                if ((Integer)this.heap.getMin() != i) {
                    System.out.println("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                    throw new RuntimeException("[ERROR] Expecting " + i + ", got " + this.heap.getMin());
                }
                this.heap.deleteMin();
            }
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test5_Put10000Random_RevertCost() {
        System.out.println("test5_Put10000Random_RevertCost()");
        this.initRevertCosts(10000);
        this.putInHeapRandom(10000);
        for (int i = 0; i < 10000; ++i) {
            if ((Integer)this.heap.getMin() != 9999 - i) {
                System.out.println("[ERROR] Expecting " + (9999 - i) + ", got " + this.heap.getMin());
                throw new RuntimeException("[ERROR] Expecting " + (9999 - i) + ", got " + this.heap.getMin());
            }
            this.heap.deleteMin();
        }
        System.out.println("---/// TEST OK ///---");
    }

    @Test
    public void test6_100x_Put10000Random_RevertCost() {
        System.out.println("test6_100x_Put10000Random_RevertCost()");
        this.initRevertCosts(10000);
        for (int j = 0; j < 100; ++j) {
            System.out.println("Test " + (j + 1) + " / 100");
            this.putInHeapRandom(10000);
            for (int i = 0; i < 10000; ++i) {
                if ((Integer)this.heap.getMin() != 9999 - i) {
                    System.out.println("[ERROR] Expecting " + (9999 - i) + ", got " + this.heap.getMin());
                    throw new RuntimeException("[ERROR] Expecting " + (9999 - i) + ", got " + this.heap.getMin());
                }
                this.heap.deleteMin();
            }
        }
        System.out.println("---/// TEST OK ///---");
    }
}

