/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.hashmap;

import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagInteger;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.junit.Test;

public class Test01_WeakHashMap {
    private static Map<Key, WeakReference<Key>> weakKeys = new WeakHashMap<Key, WeakReference<Key>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key getKey(int keyNum) {
        Key key = new Key(keyNum);
        WeakReference<Key> originalRef = weakKeys.get(key);
        if (originalRef != null) {
            Key original = (Key)originalRef.get();
            if (original != null) {
                return original;
            }
            Map<Key, WeakReference<Key>> map = weakKeys;
            synchronized (map) {
                originalRef = weakKeys.get(key);
                if (originalRef == null) {
                    weakKeys.put(key, new WeakReference<Key>(key));
                    return key;
                }
                original = (Key)originalRef.get();
                if (original != null) {
                    return original;
                }
                weakKeys.put(key, new WeakReference<Key>(key));
                return key;
            }
        }
        Map<Key, WeakReference<Key>> map = weakKeys;
        synchronized (map) {
            originalRef = weakKeys.get(key);
            if (originalRef == null) {
                weakKeys.put(key, new WeakReference<Key>(key));
                return key;
            }
            Key original = (Key)originalRef.get();
            if (original != null) {
                return original;
            }
            weakKeys.put(key, new WeakReference<Key>(key));
            return key;
        }
    }

    @Test
    public void test() {
        int i;
        int threadNum = 100;
        Thread[] threads = new Thread[threadNum];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread((Runnable)new KeyManipulator(i), "KeyManipulator-" + i);
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        System.gc();
        for (i = 0; !Key.isInstancesGC() && i < 20; ++i) {
            Key.logInstances();
            System.out.println("Not all instances of Key has been gc()ed!");
            System.gc();
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        Key.logInstances();
        if (!Key.isInstancesGC()) {
            throw new RuntimeException("Key instances were not gc()ed!");
        }
        System.out.println("---/// TEST OK ///---");
    }

    private static class KeyManipulator
    implements Runnable {
        private int ref;

        public KeyManipulator(int ref) {
            this.ref = ref;
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                Key key = Test01_WeakHashMap.getKey(i);
                System.out.println("Thread[" + this.ref + "]: got key: " + key);
            }
        }
    }

    private static class Key {
        private static FlagInteger instances = new FlagInteger(Integer.valueOf(0));
        private int key;

        public static ImmutableFlag<Integer> getInstances() {
            return instances.getImmutable();
        }

        public static void logInstances() {
            System.out.println("Key #instances: " + instances.getFlag());
        }

        public static boolean isInstancesGC() {
            return (Integer)instances.getFlag() == 0;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            instances.decrement(1);
        }

        public Key(int key) {
            instances.increment(1);
            this.key = key;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return ((Key)obj).key == this.key;
        }

        public String toString() {
            return super.toString() + "[" + this.key + "]";
        }
    }
}

