/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.IniFile;
import cz.cuni.amis.utils.SafeEquals;
import java.io.File;
import org.junit.Test;

public class Test05_IniFile
extends BaseTest {
    public static final String INI_FILE_NAME = "temp_test_ini_file_to_be_deleted.ini";

    @Test
    public void test01() {
        String section2Name;
        IniFile.Section section2;
        File file = new File(INI_FILE_NAME);
        log.info("Checking INI FILE manual creation");
        IniFile written = new IniFile();
        String section1Name = "SEC1";
        IniFile.Section section1 = written.addSection(section1Name);
        if (section1 != written.getSection(section1Name)) {
            this.testFailed("Failed to add section " + section1Name);
        }
        section1.set("KEY1", "VALUE1", "This is comment for KEY1=VALUE1");
        if (!SafeEquals.equals((Object)"VALUE1", (Object)section1.get("KEY1"))) {
            this.testFailed("Failed to set KEY1=VALUE1");
        }
        section1.addComment("KEY1=old value1", "This is comment for OLD value for KEY1");
        section1.set("KEY2", "VALUE2", "This is comment for KEY2=VALUE2");
        if (!SafeEquals.equals((Object)"VALUE2", (Object)section1.get("KEY2"))) {
            this.testFailed("Failed to set KEY2=VALUE2");
        }
        section1.addComment("KEY2=old value2", "This is comment for OLD value for KEY2");
        if (!SafeEquals.equals((Object)"VALUE1", (Object)section1.get("KEY1"))) {
            this.testFailed("Failed to set KEY2=VALUE2");
        }
        if (section1.getKeys().size() != 2) {
            this.testFailed("Failed to set keys, expected 2 != " + section1.getKeys().size());
        }
        if (!SafeEquals.equals((Object)"VALUE1", (Object)section1.get("KEY1"))) {
            this.testFailed("Failed to set KEY1=VALUE1");
        }
        if (!SafeEquals.equals((Object)"VALUE2", (Object)section1.get("KEY2"))) {
            this.testFailed("Failed to set KEY2=VALUE2");
        }
        if ((section2 = written.addSection(section2Name = "SEC2")) != written.getSection(section2Name)) {
            this.testFailed("Failed to add section " + section2Name);
        }
        section2.set("KEY3", "VALUE3", "This is comment for KEY3=VALUE3");
        if (!SafeEquals.equals((Object)"VALUE3", (Object)section2.get("KEY3"))) {
            this.testFailed("Failed to set KEY3=VALUE3");
        }
        section2.addComment("KEY3=old value3", "This is comment for OLD value for KEY3");
        section2.set("KEY4", "VALUE4", "This is comment for KEY4=VALUE4");
        if (!SafeEquals.equals((Object)"VALUE4", (Object)section2.get("KEY4"))) {
            this.testFailed("Failed to set KEY4=VALUE4");
        }
        section2.addComment("KEY4=old value4", "This is comment for OLD value for KEY4");
        if (section2.getKeys().size() != 2) {
            this.testFailed("Failed to set keys, expected 2 != " + section1.getKeys().size());
        }
        if (!SafeEquals.equals((Object)"VALUE3", (Object)section2.get("KEY3"))) {
            this.testFailed("Failed to set KEY3=VALUE3");
        }
        if (!SafeEquals.equals((Object)"VALUE4", (Object)section2.get("KEY4"))) {
            this.testFailed("Failed to set KEY4=VALUE4");
        }
        log.info("OK");
        log.info("Writing INI FILE into " + file.getAbsolutePath());
        written.output(file);
        if (!file.isFile() && !file.exists()) {
            this.testFailed("FAILED TO SAVE THE INI FILE INTO: " + file.getAbsolutePath());
        }
        log.info("PRINTING WRITTEN");
        log.info("\n" + written.output());
        log.info("Reading INI FILE from " + file.getAbsolutePath());
        IniFile read = new IniFile(file);
        log.info("PRINTING READ");
        log.info("\n" + read.output());
        log.info("Comparing WRITTEN ---> READ");
        for (IniFile.Section writtenSection : written.getSections()) {
            log.info("Checking section [" + writtenSection.getName() + "]");
            IniFile.Section readSection = written.getSection(writtenSection.getName());
            if (readSection == null) {
                this.testFailed("Section [" + writtenSection.getName() + "] HAS NOT BEEN READ!");
            }
            for (String key : readSection.getKeys()) {
                log.info("Checking key: " + key);
                if (SafeEquals.equals((Object)readSection.get(key), (Object)writtenSection.get(key))) continue;
                this.testFailed("WRITTEN " + writtenSection.getName() + "." + key + " == " + writtenSection.get(key) + " != " + readSection.get(key) + " == READ " + readSection.getName() + "." + key);
            }
        }
        log.info("OK");
        log.info("Comparing READ ---> WRITTEN");
        for (IniFile.Section readSection : read.getSections()) {
            log.info("Checking section [" + readSection.getName() + "]");
            IniFile.Section writtenSection = written.getSection(readSection.getName());
            if (writtenSection == null) {
                this.testFailed("Section [" + readSection.getName() + "] HAS NOT BEEN WRITTEN!");
            }
            for (String key : readSection.getKeys()) {
                log.info("Checking key: " + key);
                if (SafeEquals.equals((Object)readSection.get(key), (Object)writtenSection.get(key))) continue;
                this.testFailed("WRITTEN " + writtenSection.getName() + "." + key + " == " + writtenSection.get(key) + " != " + readSection.get(key) + " == READ " + readSection.getName() + "." + key);
            }
        }
        log.info("OK");
        file.delete();
        this.testOk();
    }
}

