/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

public class Throughput {
    private long lastTime = -1L;
    private long records = 0L;
    private long data = 0L;
    private long firstDataTime = -1L;
    private long totalRecords = 0L;
    private long totalData = 0L;
    private String units;
    private double throughput = 0.0;
    private boolean reporting = false;
    private String name = "Throughput";

    public Throughput(String units) {
        this.units = units;
    }

    public boolean isReporting() {
        return this.reporting;
    }

    public void setReporting(boolean reporting) {
        this.reporting = reporting;
    }

    public double getThroughput() {
        return this.throughput;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void add(long data) {
        if (this.firstDataTime < 0L) {
            this.firstDataTime = System.currentTimeMillis();
        }
        if (this.lastTime < 0L) {
            this.lastTime = System.currentTimeMillis();
            return;
        }
        this.data += data;
        ++this.records;
        this.totalData += data;
        ++this.totalRecords;
        if (System.currentTimeMillis() - this.lastTime > 1000L) {
            if (this.isReporting()) {
                System.out.println("[INFO]  " + this.name + ": " + this.data + " " + this.units + " / sec | " + this.records + " records / sec");
            }
            this.data = 0L;
            this.records = 0L;
            this.lastTime = System.currentTimeMillis();
        }
    }

    public long getTotalData() {
        return this.totalData;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public double getCurrentThroughput() {
        long time = System.currentTimeMillis() - this.firstDataTime;
        if (time < 1L) {
            return 0.0;
        }
        return (double)this.totalData / ((double)time / 1000.0);
    }

    public double getCheckThroughput() {
        return this.throughput;
    }

    public void check() {
        this.throughput = this.getCurrentThroughput();
        this.data = 0L;
        this.records = 0L;
        this.totalData = 0L;
        this.totalRecords = 0L;
        this.lastTime = -1L;
        this.firstDataTime = -1L;
    }
}

