/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.fsm;

import cz.cuni.amis.fsm.FSMBuildException;
import cz.cuni.amis.fsm.FSMInitialState;
import cz.cuni.amis.fsm.FSMOriginalState;
import cz.cuni.amis.fsm.FSMState;
import cz.cuni.amis.fsm.FSMTerminalState;
import cz.cuni.amis.fsm.FSMTransition;
import cz.cuni.amis.fsm.IFSM;
import cz.cuni.amis.fsm.IFSMState;
import cz.cuni.amis.fsm.IFSMTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class FSM<SYMBOL, CONTEXT>
implements IFSM<SYMBOL, CONTEXT> {
    private Collection<StateWrapper<SYMBOL, CONTEXT>> states;
    private Collection<IFSMTransition<SYMBOL, CONTEXT>> transitions;
    private StateWrapper<SYMBOL, CONTEXT> initialState = null;
    private StateWrapper<SYMBOL, CONTEXT> currentState = null;
    private Logger log = null;
    private Object mutex = new Object();

    public Collection<StateWrapper<SYMBOL, CONTEXT>> getStates() {
        return Collections.unmodifiableCollection(this.states);
    }

    public Collection<IFSMTransition<SYMBOL, CONTEXT>> getTransitions() {
        return Collections.unmodifiableCollection(this.transitions);
    }

    public static IFSMState getState(Class<? extends IFSMState> state, Logger log) {
        try {
            return state.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FSMBuildException("can't construct " + state.getClass().getName() + ": " + e.getMessage(), log);
        }
    }

    protected static IFSMTransition getTransition(Class<? extends IFSMTransition> transition, Logger log) {
        try {
            return transition.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new FSMBuildException("can't construct " + transition.getClass().getName() + ": " + e.getMessage(), log);
        }
    }

    public FSM(CONTEXT context, Class<? extends IFSMState<SYMBOL, CONTEXT>> state, Logger log) {
        this(context, FSM.getState(state, log), log);
    }

    public FSM(CONTEXT context, IFSMState<SYMBOL, CONTEXT> state, Logger log) {
        this(context, new IFSMState[]{state}, null, log);
    }

    public FSM(CONTEXT context, IFSMState<SYMBOL, CONTEXT>[] states, IFSMTransition[] transitions, Logger log) {
        StateWrapper[] tempStates;
        this.log = log;
        if (states == null) {
            throw new FSMBuildException("states can't be null", log);
        }
        HashMap statesMap = new HashMap();
        HashMap transitionsMap = new HashMap();
        Object[] objectArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            IFSMState<SYMBOL, CONTEXT> state = objectArray[n2];
            if (state != null) {
                StateWrapper<SYMBOL, CONTEXT> wrapper = new StateWrapper<SYMBOL, CONTEXT>(state, log);
                statesMap.put(state.getClass(), wrapper);
            }
            ++n2;
        }
        if (transitions != null) {
            objectArray = transitions;
            n = transitions.length;
            n2 = 0;
            while (n2 < n) {
                Object transition = objectArray[n2];
                if (transition != null) {
                    transitionsMap.put(transition.getClass(), transition);
                    this.transitions.add((IFSMTransition<SYMBOL, CONTEXT>)transition);
                }
                ++n2;
            }
        }
        StateWrapper[] stateWrapperArray = tempStates = statesMap.values().toArray(new StateWrapper[0]);
        int n3 = tempStates.length;
        n = 0;
        while (n < n3) {
            StateWrapper wrapper = stateWrapperArray[n];
            wrapper.initTransitionMap(statesMap, transitionsMap);
            ++n;
        }
        this.states = statesMap.values();
        this.transitions = transitionsMap.values();
        for (StateWrapper<SYMBOL, CONTEXT> wrapper : this.states) {
            if (!((StateWrapper)wrapper).myState.getClass().isAnnotationPresent(FSMInitialState.class)) continue;
            if (this.initialState != null) {
                throw new FSMBuildException("there are more then one initial state, examples: " + ((StateWrapper)this.initialState).myState.getClass() + ", " + ((StateWrapper)wrapper).myState.getClass(), log);
            }
            this.initialState = wrapper;
        }
        if (this.initialState == null) {
            throw new FSMBuildException("Failed to initialize the FSM as there is no initial state defined. Note that at least one state class must be flagged with @FSMInitialState annotation!", log);
        }
        this.init(context);
    }

    private void init(CONTEXT context) {
        this.currentState = this.initialState;
        for (StateWrapper<SYMBOL, CONTEXT> stateWrapper : this.states) {
            stateWrapper.init(context);
        }
        for (IFSMTransition iFSMTransition : this.transitions) {
            iFSMTransition.init(context);
        }
        if (this.currentState == null) {
            throw new IllegalStateException("currentState of the FSM is 'null' after the init! Ivalid state of the FSM object, you've hit a bug!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTerminal() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentState.isTerminal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(CONTEXT context, SYMBOL symbol) {
        Object object = this.mutex;
        synchronized (object) {
            this.currentState = this.currentState.pushSymbol(context, symbol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restart(CONTEXT context) {
        Object object = this.mutex;
        synchronized (object) {
            this.currentState = this.initialState;
            for (StateWrapper<SYMBOL, CONTEXT> stateWrapper : this.states) {
                stateWrapper.restart(context);
            }
            for (IFSMTransition iFSMTransition : this.transitions) {
                iFSMTransition.restart(context);
            }
            if (this.currentState == null) {
                throw new IllegalStateException("currentState of the FSM is 'null' after the restart! Ivalid state of the FSM object, you've hit a bug!");
            }
        }
    }

    protected static class StateWrapper<SYMBOL, CONTEXT>
    implements IFSMState<SYMBOL, CONTEXT> {
        private IFSMState<SYMBOL, CONTEXT> myState;
        private Map<Class, TransitionWrapper<SYMBOL, CONTEXT>> transitions = new HashMap<Class, TransitionWrapper<SYMBOL, CONTEXT>>();
        private boolean terminal;
        private Logger log;

        public StateWrapper(IFSMState<SYMBOL, CONTEXT> state, Logger log) {
            this.log = log;
            if (!state.getClass().isAnnotationPresent(FSMState.class)) {
                throw new FSMBuildException("state " + state.getClass() + " doesn't contain @State annotation", log);
            }
            this.myState = state;
            this.terminal = state.getClass().isAnnotationPresent(FSMTerminalState.class);
        }

        protected void initTransitionMap(Map<Class, StateWrapper<SYMBOL, CONTEXT>> states, Map<Class, IFSMTransition<SYMBOL, CONTEXT>> transitions) {
            FSMState s = this.myState.getClass().getAnnotation(FSMState.class);
            FSMTransition[] fSMTransitionArray = s.map();
            int n = fSMTransitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FSMTransition transition = fSMTransitionArray[n2];
                if (transition.symbol().length == 0) {
                    throw new FSMBuildException("state " + this.myState.getClass() + ": one of the transition doesn't have symbols specified", this.log);
                }
                StateWrapper<SYMBOL, CONTEXT> targetState = null;
                if (transition.state() != FSMOriginalState.class && (targetState = states.get(transition.state())) == null) {
                    targetState = new StateWrapper<SYMBOL, CONTEXT>(FSM.getState(transition.state(), this.log), this.log);
                    states.put(transition.state(), targetState);
                    targetState.initTransitionMap(states, transitions);
                }
                ArrayList nextTransitions = new ArrayList(transition.transition().length);
                Class<? extends IFSMTransition>[] classArray = transition.transition();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<? extends IFSMTransition> tran = classArray[n4];
                    IFSMTransition t = transitions.get(tran);
                    if (t == null) {
                        t = FSM.getTransition(tran, this.log);
                        transitions.put(tran, t);
                    }
                    nextTransitions.add(t);
                    ++n4;
                }
                TransitionWrapper<SYMBOL, CONTEXT> transitionWrapper = new TransitionWrapper<SYMBOL, CONTEXT>(targetState, nextTransitions, this.log);
                Class[] classArray2 = transition.symbol();
                int n5 = classArray2.length;
                n3 = 0;
                while (n3 < n5) {
                    Class symbol = classArray2[n3];
                    this.transitions.put(symbol, transitionWrapper);
                    ++n3;
                }
                ++n2;
            }
        }

        @Override
        public void init(CONTEXT context) {
            this.log.finest("FSM: " + this.myState + " init()");
            this.myState.init(context);
        }

        @Override
        public void restart(CONTEXT context) {
            this.log.finest("FSM: " + this.myState + " restart()");
            this.myState.restart(context);
        }

        @Override
        public void stateEntering(CONTEXT context, IFSMState<SYMBOL, CONTEXT> fromState, SYMBOL symbol) {
            this.log.finest("FSM[" + fromState + "]: entering state " + this.myState);
            this.myState.stateEntering(context, fromState, symbol);
        }

        @Override
        public void stateLeaving(CONTEXT context, IFSMState<SYMBOL, CONTEXT> toState, SYMBOL symbol) {
            this.log.finest("FSM[" + this.myState + "]: leaving state");
            this.myState.stateLeaving(context, toState, symbol);
        }

        @Override
        public void stateSymbol(CONTEXT context, SYMBOL symbol) {
            this.log.finest("FSM[" + this.myState + "]: consuming symbol " + symbol);
            this.myState.stateSymbol(context, symbol);
        }

        public StateWrapper pushSymbol(CONTEXT context, SYMBOL symbol) {
            TransitionWrapper<SYMBOL, CONTEXT> transition = this.transitions.get(symbol.getClass());
            if (transition == null) {
                this.stateSymbol(context, symbol);
                return this;
            }
            return transition.step(context, this, symbol);
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public String toString() {
            return "FSM$StateWrapper(myState=" + this.myState + ")";
        }

        public IFSMState<SYMBOL, CONTEXT> getWrappedState() {
            return this.myState;
        }

        public Map<Class, TransitionWrapper<SYMBOL, CONTEXT>> getTransitions() {
            return Collections.unmodifiableMap(this.transitions);
        }
    }

    protected static class TransitionWrapper<SYMBOL, CONTEXT> {
        private StateWrapper<SYMBOL, CONTEXT> target;
        private List<IFSMTransition<SYMBOL, CONTEXT>> transitions;
        private Logger log;

        public TransitionWrapper(StateWrapper<SYMBOL, CONTEXT> target, Logger log) {
            this(target, null, log);
        }

        public TransitionWrapper(StateWrapper<SYMBOL, CONTEXT> target, List<IFSMTransition<SYMBOL, CONTEXT>> transitions, Logger log) {
            this.log = log;
            this.target = target;
            this.transitions = transitions;
        }

        public StateWrapper<SYMBOL, CONTEXT> step(CONTEXT context, StateWrapper<SYMBOL, CONTEXT> fromState, SYMBOL bySymbol) {
            this.log.finer("FSM[" + fromState.getWrappedState() + "]: symbol " + bySymbol);
            if (this.target == null) {
                for (IFSMTransition<SYMBOL, CONTEXT> transition : this.transitions) {
                    this.log.finest("FSM[" + fromState.getWrappedState() + "]: invoking transition " + transition);
                    transition.stepped(context, ((StateWrapper)fromState).myState, bySymbol, this.target);
                }
                return fromState;
            }
            fromState.stateLeaving(context, this.target, bySymbol);
            for (IFSMTransition<SYMBOL, CONTEXT> transition : this.transitions) {
                this.log.finest("FSM[" + fromState.getWrappedState() + "]: invoking transition " + transition);
                transition.stepped(context, ((StateWrapper)fromState).myState, bySymbol, ((StateWrapper)this.target).myState);
            }
            this.target.stateEntering(context, ((StateWrapper)fromState).myState, bySymbol);
            return this.target;
        }

        public StateWrapper<SYMBOL, CONTEXT> getTarget() {
            return this.target;
        }
    }
}

