/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.keys.KeyInfo;
import com.sun.org.apache.xml.internal.security.keys.content.KeyValue;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.EncryptedKeyToken;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.core.SecurityTokenReference;
import com.sun.xml.wss.core.X509SecurityToken;
import com.sun.xml.wss.core.reference.DirectReference;
import com.sun.xml.wss.core.reference.KeyIdentifier;
import com.sun.xml.wss.core.reference.X509IssuerSerial;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.misc.DefaultSecurityEnvironmentImpl;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.SymmetricKeyBinding;
import com.sun.xml.wss.saml.Assertion;
import com.sun.xml.wss.saml.AssertionUtil;
import com.sun.xml.wss.saml.util.SAMLUtil;
import java.math.BigInteger;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyResolver {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public static Key getKey(KeyInfoHeaderBlock keyInfo, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        Key returnKey;
        block9: {
            HashMap tokenCache = context.getTokenCache();
            try {
                SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
                if (keyInfo.containsSecurityTokenReference()) {
                    return KeyResolver.processSecurityTokenReference(keyInfo, sig, context);
                }
                if (keyInfo.containsKeyName()) {
                    EncryptionPolicy policy = (EncryptionPolicy)context.getInferredPolicy();
                    String keynameString = keyInfo.getKeyNameString(0);
                    if (policy != null) {
                        SymmetricKeyBinding keyBinding = null;
                        keyBinding = (SymmetricKeyBinding)policy.newSymmetricKeyBinding();
                        keyBinding.setKeyIdentifier(keynameString);
                    }
                    returnKey = context.getSecurityEnvironment().getSecretKey(context.getExtraneousProperties(), keynameString, false);
                    break block9;
                }
                if (keyInfo.containsKeyValue()) {
                    returnKey = KeyResolver.resolveKeyValue(secureMsg, keyInfo.getKeyValue(0), sig, context);
                    break block9;
                }
                if (keyInfo.containsX509Data()) {
                    returnKey = KeyResolver.resolveX509Data(secureMsg, keyInfo.getX509Data(0), sig, context);
                    break block9;
                }
                log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                XWSSecurityException xwsse = new XWSSecurityException("Support for processing information in the given ds:KeyInfo is not present");
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, xwsse.getMessage(), xwsse);
            }
            catch (WssSoapFaultException wsse) {
                throw wsse;
            }
            catch (XWSSecurityException xwsse) {
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
            }
        }
        if (returnKey == null) {
            log.log(Level.SEVERE, "WSS0600.illegal.token.reference");
            XWSSecurityException xwsse = new XWSSecurityException("Referenced security token could not be retrieved");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
        }
        return returnKey;
    }

    public static Key resolveSamlAssertion(SecurableSoapMessage secureMsg, Assertion samlAssertion, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        try {
            Element keyInfoElem = AssertionUtil.getSubjectConfirmationKeyInfo(samlAssertion.toElement(null));
            KeyInfo keyInfo = new KeyInfo(keyInfoElem, null);
            if (keyInfo.containsKeyValue()) {
                return KeyResolver.resolveKeyValue(secureMsg, keyInfo.itemKeyValue(0), sig, context);
            }
            if (keyInfo.containsX509Data()) {
                return KeyResolver.resolveX509Data(secureMsg, keyInfo.itemX509Data(0), sig, context);
            }
            log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
            throw new XWSSecurityException("Unsupported Key Information");
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Key processSecurityTokenReference(KeyInfoHeaderBlock keyInfo, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        void var3_32;
        HashMap tokenCache = context.getTokenCache();
        SecurableSoapMessage secureMsg = context.getSecurableSoapMessage();
        SecurityTokenReference str = keyInfo.getSecurityTokenReference(0);
        ReferenceElement refElement = str.getReference();
        EncryptionPolicy policy = (EncryptionPolicy)context.getInferredPolicy();
        if (refElement instanceof KeyIdentifier) {
            KeyIdentifier keyId = (KeyIdentifier)refElement;
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier".equals(keyId.getValueType()) || "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3SubjectKeyIdentifier".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                    keyBinding.setReferenceType("Identifier");
                }
                if (sig) {
                    PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                    return var3_32;
                }
                PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_32;
            }
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(keyId.getValueType())) {
                if (policy != null) {
                    AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                    keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
                    keyBinding.setReferenceType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
                }
                String assertionID = keyId.getDecodedReferenceValue();
                Assertion samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context);
                return var3_32;
            }
            if (policy != null) {
                AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
                keyBinding = (AuthenticationTokenPolicy.SAMLAssertionBinding)policy.newSAMLAssertionKeyBinding();
            }
            Assertion samlAssertion = null;
            String assertionID = keyId.getDecodedReferenceValue();
            try {
                samlAssertion = KeyResolver.resolveSAMLToken(str, assertionID, context);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (samlAssertion != null) {
                Key key = KeyResolver.resolveSamlAssertion(secureMsg, samlAssertion, sig, context);
                return var3_32;
            }
            if (sig) {
                PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
                return var3_32;
            }
            PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), KeyResolver.getDecodedBase64EncodedData(keyId.getReferenceValue()));
            return var3_32;
        }
        if (refElement instanceof DirectReference) {
            String uri = ((DirectReference)refElement).getURI();
            AuthenticationTokenPolicy.X509CertificateBinding keyBinding = null;
            String valueType = ((DirectReference)refElement).getValueType();
            if (policy != null) {
                keyBinding = (AuthenticationTokenPolicy.X509CertificateBinding)policy.newX509CertificateKeyBinding();
                keyBinding.setReferenceType("Direct");
                keyBinding.setValueType(valueType);
            }
            if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3".equals(valueType)) {
                String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
                X509SecurityToken token = (X509SecurityToken)KeyResolver.resolveToken(wsuId, tokenCache, secureMsg);
                Key key = KeyResolver.resolveX509Token(secureMsg, token, sig, context);
                return var3_32;
            }
            if (null != valueType) {
                log.log(Level.SEVERE, "WSS0337.unsupported.directref.mechanism", new Object[]{((DirectReference)refElement).getValueType()});
                XWSSecurityException xwsse = new XWSSecurityException("unsupported directreference ValueType " + ((DirectReference)refElement).getValueType());
                throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
            }
            String wsuId = SecurableSoapMessage.getIdFromFragmentRef(uri);
            SecurityToken token = KeyResolver.resolveToken(wsuId, tokenCache, secureMsg);
            if (token instanceof X509SecurityToken) {
                Key key = KeyResolver.resolveX509Token(secureMsg, (X509SecurityToken)token, sig, context);
                return var3_32;
            }
            if (token instanceof EncryptedKeyToken) {
                KeyInfoHeaderBlock kiHB = ((EncryptedKeyToken)token).getKeyInfo();
                SecurityTokenReference sectr = kiHB.getSecurityTokenReference(0);
                ReferenceElement refElem = sectr.getReference();
                Key key = ((EncryptedKeyToken)token).getSecretKey(KeyResolver.getKey(kiHB, true, context));
                return var3_32;
            }
            String message = " Cannot Resolve URI " + uri;
            log.log(Level.SEVERE, "WSS0337.unsupported.directref.mechanism", new Object[]{message});
            XWSSecurityException xwsse = new XWSSecurityException(message);
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_SECURITY_TOKEN_UNAVAILABLE, xwsse.getMessage(), xwsse);
        }
        if (!(refElement instanceof X509IssuerSerial)) {
            log.log(Level.SEVERE, "WSS0338.unsupported.reference.mechanism");
            XWSSecurityException xwsse = new XWSSecurityException("Key reference mechanism not supported");
            throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_UNSUPPORTED_SECURITY_TOKEN, xwsse.getMessage(), xwsse);
        }
        BigInteger serialNumber = ((X509IssuerSerial)refElement).getSerialNumber();
        String issuerName = ((X509IssuerSerial)refElement).getIssuerName();
        if (sig) {
            PublicKey publicKey = context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), serialNumber, issuerName);
            return var3_32;
        }
        PrivateKey privateKey = context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), serialNumber, issuerName);
        return var3_32;
    }

    public static Key resolveX509Token(SecurableSoapMessage secureMsg, X509SecurityToken token, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        if (sig) {
            X509Certificate cert = token.getCertificate();
            context.getSecurityEnvironment().updateOtherPartySubject(DefaultSecurityEnvironmentImpl.getSubject(context), cert);
            return cert.getPublicKey();
        }
        return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), token.getCertificate());
    }

    public static Key resolveKeyValue(SecurableSoapMessage secureMsg, KeyValue keyValue, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        keyValue.getElement().normalize();
        try {
            if (sig) {
                return keyValue.getPublicKey();
            }
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), keyValue.getPublicKey(), false);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0601.illegal.key.value", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public static Key resolveX509Data(SecurableSoapMessage secureMsg, X509Data x509Data, boolean sig, FilterProcessingContext context) throws XWSSecurityException {
        x509Data.getElement().normalize();
        X509Certificate cert = null;
        try {
            if (!x509Data.containsCertificate()) {
                if (x509Data.containsSKI()) {
                    if (sig) {
                        return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), x509Data.itemSKI(0).getSKIBytes());
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), x509Data.itemSKI(0).getSKIBytes());
                }
                if (x509Data.containsSubjectName()) {
                    log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                    throw new XWSSecurityException("X509SubjectName child element of X509Data is not yet supported by our implementation");
                }
                if (x509Data.containsIssuerSerial()) {
                    if (sig) {
                        return context.getSecurityEnvironment().getPublicKey(context.getExtraneousProperties(), x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                    }
                    return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), x509Data.itemIssuerSerial(0).getSerialNumber(), x509Data.itemIssuerSerial(0).getIssuerName());
                }
                log.log(Level.SEVERE, "WSS0339.unsupported.keyinfo");
                throw new XWSSecurityException("Unsupported child element of X509Data encountered");
            }
            cert = x509Data.itemCertificate(0).getX509Certificate();
            if (sig) {
                return cert.getPublicKey();
            }
            return context.getSecurityEnvironment().getPrivateKey(context.getExtraneousProperties(), cert);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0602.illegal.x509.data", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    private static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            throw new XWSSecurityException("Unable to decode Base64 encoded data", e);
        }
    }

    private static SecurityToken resolveToken(String uri, HashMap cache, SecurableSoapMessage secureMsg) throws XWSSecurityException {
        try {
            SecurityToken token = (SecurityToken)cache.get(uri);
            if (token != null) {
                return token;
            }
            Element tokenNode = null;
            tokenNode = secureMsg.getElementById(uri);
            tokenNode.normalize();
            if (tokenNode == null) {
                throw new XWSSecurityException("Token not found");
            }
            if ("BinarySecurityToken".equals(tokenNode.getLocalName())) {
                token = new X509SecurityToken((SOAPElement)tokenNode);
            } else if ("EncryptedKey".equals(tokenNode.getLocalName())) {
                token = new EncryptedKeyToken((SOAPElement)tokenNode);
            }
            cache.put(uri, token);
            return token;
        }
        catch (Exception ex) {
            throw new XWSSecurityException(ex);
        }
    }

    private static Assertion resolveSAMLToken(SecurityTokenReference tokenRef, String assertionId, FilterProcessingContext context) throws XWSSecurityException {
        Assertion ret = (Assertion)context.getTokenCache().get(assertionId);
        if (ret != null) {
            return ret;
        }
        Element tokenElement = null;
        tokenElement = tokenRef.getSamlAuthorityBinding() != null ? context.getSecurityEnvironment().locateSAMLAssertion(context.getExtraneousProperties(), tokenRef.getSamlAuthorityBinding(), assertionId, (Document)context.getSOAPMessage().getSOAPPart()) : SAMLUtil.locateSamlAssertion(assertionId, (Document)context.getSOAPMessage().getSOAPPart());
        KeyResolver.addAuthorityId(tokenElement, context);
        try {
            ret = AssertionUtil.fromElement(tokenElement);
        }
        catch (Exception e) {
            throw new XWSSecurityException(e);
        }
        context.getTokenCache().put(assertionId, ret);
        return ret;
    }

    private static void addAuthorityId(Element assertion, FilterProcessingContext fp) {
        EncryptionPolicy ep = (EncryptionPolicy)fp.getInferredPolicy();
        if (ep != null) {
            AuthenticationTokenPolicy.SAMLAssertionBinding kb = (AuthenticationTokenPolicy.SAMLAssertionBinding)ep.getKeyBinding();
            String issuer = assertion.getAttribute("Issuer");
            kb.setAuthorityIdentifier(issuer);
        }
    }
}

