/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.spi;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.ProvisionListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProvisionListenerBinding
implements Element {
    private final Object source;
    private final Matcher<? super Key<?>> keyMatcher;
    private final List<ProvisionListener> listeners;

    ProvisionListenerBinding(Object source, Matcher<? super Key<?>> typeMatcher, ProvisionListener[] listeners) {
        this.source = source;
        this.keyMatcher = typeMatcher;
        this.listeners = ImmutableList.copyOf((Object[])listeners);
    }

    public List<ProvisionListener> getListeners() {
        return this.listeners;
    }

    public Matcher<? super Key<?>> getKeyMatcher() {
        return this.keyMatcher;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public <R> R acceptVisitor(ElementVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindListener(this.keyMatcher, this.listeners.toArray(new ProvisionListener[this.listeners.size()]));
    }
}

